/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ArchiveMessage;
import freenetmessageboard.core.ChessMessage;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import java.util.Set;

public abstract class MessageFilter {
    private static MessageFilter acceptAllMessageFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            return true;
        }
    };
    private static MessageFilter otherUsersPostsMessageFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            if (!(message instanceof PostMessage)) {
                return false;
            }
            return !message.getUniqueId().startsWith(PersonalInfo.instance().getPublicKey());
        }
    };
    private static MessageFilter allPostsMessageFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            return message instanceof PostMessage;
        }
    };
    private static MessageFilter chessMessagesOnlyFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            boolean bl = message instanceof ChessMessage;
            return message instanceof ChessMessage;
        }
    };
    private static MessageFilter archiveMessagesFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            return message instanceof ArchiveMessage;
        }
    };
    private static MessageFilter userMessagesAndCommentsOnlyFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            return message instanceof UserMessage || message instanceof UserCommentMessage;
        }
    };
    private static MessageFilter userMessagesOnlyFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            return message instanceof UserMessage;
        }
    };
    private static MessageFilter originalNonArchiveMessagesOnlyFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            if (message instanceof ArchiveMessage) {
                return false;
            }
            return message.getSourceKey().equals(message.getOriginalPublicKey());
        }
    };
    private static MessageFilter originalMessagesOnlyFilter = new MessageFilter(){

        boolean acceptMessage(Message message) {
            return message.getSourceKey().equals(message.getOriginalPublicKey());
        }
    };

    abstract boolean acceptMessage(Message var1);

    public static MessageFilter getAcceptAllMessageFilter() {
        return acceptAllMessageFilter;
    }

    public static MessageFilter getUserMessagesAndCommentsOnlyFilter() {
        return userMessagesAndCommentsOnlyFilter;
    }

    public static MessageFilter getUserMessagesOnlyFilter() {
        return userMessagesOnlyFilter;
    }

    public static MessageFilter getAllPostsMessageFilter() {
        return allPostsMessageFilter;
    }

    public static MessageFilter getArchiveMessagesOnlyFilter() {
        return archiveMessagesFilter;
    }

    public static MessageFilter originalNonArchiveMessagesOnlyFilter() {
        return originalNonArchiveMessagesOnlyFilter;
    }

    public static MessageFilter originalMessagesOnlyFilter() {
        return originalMessagesOnlyFilter;
    }

    public static MessageFilter ignoreByUniqueIDFilter(final Set set) {
        return new MessageFilter(){

            public boolean acceptMessage(Message message) {
                return !set.contains(message.getUniqueId());
            }
        };
    }

    public static MessageFilter getMessageTypeFilter(final Class clazz) {
        return new MessageFilter(){

            public boolean acceptMessage(Message message) {
                return message.getClass().equals(clazz);
            }
        };
    }

    public static MessageFilter getChessMessagesOnlyFilter() {
        return chessMessagesOnlyFilter;
    }

    public static MessageFilter getOtherUsersPostsMessageFilter() {
        return otherUsersPostsMessageFilter;
    }
}

