/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.Main;
import freenetmessageboard.core.ArchiveMessage;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FreenetNetworkSettings;
import freenetmessageboard.core.MessageArchive;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.fcpinterface.FCPFacade;
import freenetmessageboard.fcpinterface.FCPInsertCallback;
import freenetmessageboard.fcpinterface.InsertInfo;
import java.util.HashMap;
import java.util.Map;

public class MessageArchiveTransmitter
implements FCPInsertCallback {
    private Map activeInserts = new HashMap();
    private static MessageArchiveTransmitter instance;

    private MessageArchiveTransmitter() {
    }

    public static synchronized MessageArchiveTransmitter instance() {
        if (instance == null) {
            instance = new MessageArchiveTransmitter();
        }
        return instance;
    }

    public synchronized void insertArchive(MessageArchive messageArchive, String string) {
        String string2 = MessageArchiveTransmitter.constructArchiveUri(PersonalInfo.instance().getPrivateKey(), string);
        CoreLogger.log("inserting archive to " + string2, 2);
        Map map = this.activeInserts;
        synchronized (map) {
            this.activeInserts.put(string2, messageArchive);
        }
        FCPFacade.instance().startFreenetInsert(this, string2, new byte[0], messageArchive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
    }

    public static String constructArchiveUri(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("SSK@");
        stringBuffer.append(string);
        stringBuffer.append("/fmb/archives/");
        stringBuffer.append(string2);
        stringBuffer.append(".zip");
        return stringBuffer.toString();
    }

    public void insertSuccesfull(String string, InsertInfo insertInfo) {
        CoreLogger.log("the insert of archive to " + PersonalInfo.instance().privateToPublicUri(string) + " was succesful.", 2);
        MessageArchive messageArchive = (MessageArchive)this.activeInserts.get(string);
        Map map = this.activeInserts;
        synchronized (map) {
            this.activeInserts.remove(string);
        }
        ArchiveMessage archiveMessage = new ArchiveMessage(PersonalInfo.instance().privateToPublicUri(string), messageArchive);
        CoreLogger.log("announcing this archive on my personal channel, announcement has " + archiveMessage.getString().length() + " chars lenth", 1);
        MessageGateway.instance().sendMessageOnPersonalChannel(archiveMessage);
        Main.getGUI().setInsertArchiveStatusString("insert message archive", true);
    }

    public boolean areThereActiveInserts() {
        return this.activeInserts.size() > 0;
    }

    public void insertFailedWithRouteNotFound(String string) {
        CoreLogger.log("the insert of archive to " + string + " failed with route not found, retrying...", 0);
        MessageArchive messageArchive = (MessageArchive)this.activeInserts.get(string);
        FCPFacade.instance().startFreenetInsert(this, string, new byte[0], messageArchive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
    }

    private String getRandomName() {
        return Double.toString(Math.random()).substring(2);
    }

    public void insertFailedWithKeyCollision(String string) {
        CoreLogger.log("the insert of archive to " + string + " failed with key collision.", 1);
        MessageArchive messageArchive = (MessageArchive)this.activeInserts.get(string);
        String string2 = MessageArchiveTransmitter.constructArchiveUri(PersonalInfo.instance().getPrivateKey(), this.getRandomName());
        CoreLogger.log("restarting insert with new uri " + string2, 1);
        FCPFacade.instance().startFreenetInsert(this, string2, new byte[0], messageArchive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
        Map map = this.activeInserts;
        synchronized (map) {
            this.activeInserts.remove(string);
            this.activeInserts.put(string2, messageArchive);
        }
    }

    public void insertFailedBadly(String string, String string2) {
        CoreLogger.log("the insert of archive to " + string + " failed: " + string2 + ", retrying...", 0);
        MessageArchive messageArchive = (MessageArchive)this.activeInserts.get(string);
        FCPFacade.instance().startFreenetInsert(this, string, new byte[0], messageArchive.getBytes(), FreenetNetworkSettings.instance().archiveInsertHtl, true);
    }
}

