/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ArchiveMessage;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FreenetNetworkSettings;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArchive;
import freenetmessageboard.core.MessageArrivedListener;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.fcpinterface.FCPFacade;
import freenetmessageboard.fcpinterface.FCPRequestCallback;
import freenetmessageboard.fcpinterface.RequestedData;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class MessageArchiveReceiver
extends AbstractTableModel
implements Runnable,
FCPRequestCallback,
MessageArrivedListener {
    private List archiveMessagesList = new LinkedList();
    private List newArchiveMessagesList = new LinkedList();
    private List newMessagesInArchiveCountList = new LinkedList();
    private List statusStringList = new LinkedList();
    private Set messagesInArchive = new HashSet();
    private Map currentRequests = new HashMap();
    private static MessageArchiveReceiver instance;
    private static String[] colNames;
    private static Class[] colClasses;

    private MessageArchiveReceiver() {
        MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getArchiveMessagesOnlyFilter());
    }

    public int getRowCount() {
        int n;
        CoreLogger.log("entering monitor this.activeMessageList", 3);
        List list = this.archiveMessagesList;
        synchronized (list) {
            CoreLogger.log("entered monitor this.activeMessageList", 3);
            n = this.archiveMessagesList.size();
            CoreLogger.log("leaving monitor this.activeMessageList", 3);
        }
        CoreLogger.log("left monitor this.activeMessageList", 3);
        return n;
    }

    private int countNewMessagesInArchive(ArchiveMessage archiveMessage) {
        String[] stringArray = archiveMessage.getUniqueIDs();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.messagesInArchive.add(stringArray[n2]);
            if (!MessagePool.instance().shouldMessageBeIgnored(stringArray[n2]) && !MessagePool.instance().containsMessage(stringArray[n2])) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getColumnCount() {
        return 7;
    }

    public Class getColumnClass(int n) {
        return colClasses[n];
    }

    public String getColumnName(int n) {
        return colNames[n];
    }

    public void requestArchive(int n) {
        ArchiveMessage archiveMessage = (ArchiveMessage)this.archiveMessagesList.get(n);
        CoreLogger.log("starting request for archive from " + archiveMessage.getUri(), 2);
        FCPFacade.instance().startFreenetRequest(this, archiveMessage.getUri(), FreenetNetworkSettings.instance().archiveRequestHtl, true);
        Map map = this.currentRequests;
        synchronized (map) {
            this.currentRequests.put(archiveMessage.getUri(), archiveMessage);
        }
        this.statusStringList.set(n, "request queued...");
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        ArchiveMessage archiveMessage;
        CoreLogger.log("entering monitor this.activeMessageList", 3);
        List list = this.archiveMessagesList;
        synchronized (list) {
            CoreLogger.log("entered monitor this.activeMessageList", 3);
            archiveMessage = (ArchiveMessage)this.archiveMessagesList.get(n);
            CoreLogger.log("leaving monitor this.activeMessageList", 3);
        }
        CoreLogger.log("left monitor this.activeMessageList", 3);
        if (n2 == 0) {
            return this.statusStringList.get(n);
        }
        if (n2 == 1) {
            return ContactList.instance().getNicknameOfPublicKey(archiveMessage.getOriginalPublicKey()) + " (" + archiveMessage.getOriginalPublicKey() + ") ";
        }
        if (n2 == 2) {
            return new Integer(archiveMessage.getUniqueIDs().length);
        }
        if (n2 == 3) {
            return this.newMessagesInArchiveCountList.get(n);
        }
        if (n2 == 4) {
            return new Integer(archiveMessage.getSize() / 1024);
        }
        if (n2 == 5) {
            return archiveMessage.getDate();
        }
        if (n2 == 6) {
            return archiveMessage.getDescription();
        }
        return "novalue";
    }

    public void run() {
        block2: while (true) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.recountNewMsgCounter();
            this.processNewMessages();
            int n = 0;
            while (true) {
                if (n >= this.archiveMessagesList.size()) continue block2;
                this.fireTableCellUpdated(n, 3);
                ++n;
            }
            break;
        }
    }

    private void recountNewMsgCounter() {
        CoreLogger.log("entering monitor this.activeMessageList", 3);
        List list = this.archiveMessagesList;
        synchronized (list) {
            CoreLogger.log("entered monitor this.activeMessageList", 3);
            int n = 0;
            while (n < this.archiveMessagesList.size()) {
                ArchiveMessage archiveMessage = (ArchiveMessage)this.archiveMessagesList.get(n);
                this.newMessagesInArchiveCountList.set(n, new Integer(this.countNewMessagesInArchive(archiveMessage)));
                ++n;
            }
            CoreLogger.log("leaving monitor this.activeMessageList", 3);
        }
        CoreLogger.log("left monitor this.activeMessageList", 3);
    }

    public static synchronized MessageArchiveReceiver instance() {
        if (instance == null) {
            instance = new MessageArchiveReceiver();
        }
        return instance;
    }

    public void start() {
        Thread thread = new Thread(instance);
        thread.setName("MessageArchiveReceiver");
        thread.start();
    }

    public void messageArrived(Message message) {
        CoreLogger.log("an archive message from " + message.getOriginalUri() + " has arrived", 2);
        CoreLogger.log("entering monitor this.activeMessageList", 3);
        List list = this.archiveMessagesList;
        synchronized (list) {
            CoreLogger.log("entered monitor this.activeMessageList", 3);
            this.newArchiveMessagesList.add(message);
            CoreLogger.log("leaving monitor this.activeMessageList", 3);
        }
        CoreLogger.log("left monitor this.activeMessageList, fireTableDataChanged", 3);
    }

    private void processNewMessages() {
        if (this.newArchiveMessagesList.size() == 0) {
            return;
        }
        CoreLogger.log("processing new archive messages...", 2);
        CoreLogger.log("entering monitor this.newArchiveMessagesList", 3);
        List list = this.newArchiveMessagesList;
        synchronized (list) {
            CoreLogger.log("entered monitor this.newArchiveMessagesList", 3);
            Iterator iterator = this.newArchiveMessagesList.iterator();
            while (iterator.hasNext()) {
                ArchiveMessage archiveMessage = (ArchiveMessage)iterator.next();
                CoreLogger.log("entering monitor this.activeMessageList", 3);
                List list2 = this.archiveMessagesList;
                synchronized (list2) {
                    CoreLogger.log("entered monitor this.activeMessageList", 3);
                    if (!this.archiveMessagesList.contains(archiveMessage)) {
                        this.archiveMessagesList.add(archiveMessage);
                        this.newMessagesInArchiveCountList.add(new Integer(this.countNewMessagesInArchive(archiveMessage)));
                        this.statusStringList.add("not receiving");
                    }
                    CoreLogger.log("leaving monitor this.activeMessageList", 3);
                }
                CoreLogger.log("left monitor this.activeMessageList, fireTableDataChanged", 3);
                CoreLogger.log("fireRowsInserted", 3);
                this.fireTableRowsInserted(this.archiveMessagesList.size() - 1, this.archiveMessagesList.size() - 1);
            }
            this.newArchiveMessagesList.clear();
            CoreLogger.log("leaving monitor this.newArchiveMessagesList", 3);
        }
        CoreLogger.log("left monitor this.newArchiveMessagesList", 3);
    }

    public void requestSuccesfull(String string, RequestedData requestedData) {
        CoreLogger.log("sucesfull requested archive from " + string, 1);
        this.statusStringList.set(this.getIndexOfUri(string), "succesfull");
        this.fireTableDataChanged();
        MessageArchive messageArchive = new MessageArchive(requestedData.getDataBytes());
        try {
            Message[] messageArray = messageArchive.getMessages();
            if (messageArray.length == 0) {
                throw new IOException("no messages in archive");
            }
            int n = 0;
            while (n < messageArray.length) {
                messageArray[n].setSource(string);
                MessagePool.instance().addMessage(string, messageArray[n]);
                messageArray[n].increaseRetrievedCounter();
                ++n;
            }
        }
        catch (IOException iOException) {
            this.statusStringList.set(this.getIndexOfUri(string), "no valid archive");
            this.fireTableDataChanged();
        }
        this.currentRequests.remove(string);
    }

    private int getIndexOfUri(String string) {
        int n;
        CoreLogger.log("getting index of archive at uri " + string, 3);
        ArchiveMessage archiveMessage = (ArchiveMessage)this.currentRequests.get(string);
        CoreLogger.log("entering monitor this.activeMessageList", 3);
        List list = this.archiveMessagesList;
        synchronized (list) {
            CoreLogger.log("entered monitor this.activeMessageList", 3);
            n = this.archiveMessagesList.indexOf(archiveMessage);
            CoreLogger.log("leaving monitor this.activeMessageList", 3);
        }
        CoreLogger.log("left monitor this.activeMessageList", 3);
        return n;
    }

    public void requestFailedWithRouteNotFound(String string) {
        CoreLogger.log("archive request for " + string + " failed with route not found", 0);
        this.statusStringList.set(this.getIndexOfUri(string), "route not found");
        this.fireTableDataChanged();
        this.currentRequests.remove(string);
    }

    public void requestFailedWithDataNotFound(String string) {
        CoreLogger.log("archive request for " + string + " failed with data not found", 2);
        this.statusStringList.set(this.getIndexOfUri(string), "data not found");
        this.fireTableDataChanged();
        this.currentRequests.remove(string);
    }

    public void requestFailedBadly(String string, String string2) {
        CoreLogger.log("archive request for " + string + " failed: " + string2, 0);
        this.statusStringList.set(this.getIndexOfUri(string), "failed badly");
        this.fireTableDataChanged();
        this.currentRequests.remove(string);
    }

    public void requestStarted(String string) {
        CoreLogger.log("archive request for " + string + " was started.", 2);
        this.statusStringList.set(this.getIndexOfUri(string), "requesting...");
        this.fireTableDataChanged();
    }

    static {
        colNames = new String[]{"status", "from", "total", "new", "kb", "date", "description"};
        colClasses = new Class[]{new String().getClass(), new String().getClass(), new Integer(2).getClass(), new Integer(2).getClass(), new Integer(2).getClass(), new String().getClass(), new String().getClass()};
    }
}

