/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class MessageArchive {
    private byte[] compressedBytes;
    private String description;
    private String messageListing;

    public MessageArchive(Message[] messageArray, String string) throws IOException {
        try {
            this.description = string;
            this.insertMessages(messageArray);
            if (!this.verifyArchive(messageArray)) {
                throw new IOException("the message archive was created but didn't pass the verifciation!");
            }
        }
        catch (IOException iOException) {
            CoreLogger.log("Exception while creating archive: " + iOException.getClass().getName() + ": " + iOException.getMessage(), 0);
            throw iOException;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public MessageArchive(byte[] byArray) {
        this.compressedBytes = byArray;
    }

    private boolean verifyArchive(Message[] messageArray) throws IOException {
        try {
            CoreLogger.log("verifying the new archive...", 2);
            StringBuffer stringBuffer = new StringBuffer();
            Message[] messageArray2 = this.getMessages();
            int n = 0;
            while (n < messageArray.length) {
                if (stringBuffer.toString().length() + messageArray[n].getUniqueId().length() + 500 > 32000) break;
                stringBuffer.append(messageArray[n].getUniqueId());
                stringBuffer.append('\n');
                ++n;
            }
            this.messageListing = stringBuffer.toString();
            CoreLogger.log("the new message archive is verified, the message listing is " + this.messageListing.length() + " chars long", 2);
            return true;
        }
        catch (IOException iOException) {
            CoreLogger.log("Exception while verifying archive: " + iOException.getClass().getName() + ": " + iOException.getMessage(), 0);
            throw iOException;
        }
    }

    public String getMessageListing() {
        return this.messageListing;
    }

    byte[] getBytes() {
        return this.compressedBytes;
    }

    Message[] getMessages() throws IOException {
        try {
            String string;
            CoreLogger.log("decompressing archive with " + this.compressedBytes.length + " bytes size", 2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.compressedBytes);
            ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
            zipInputStream.getNextEntry();
            InputStreamReader inputStreamReader = new InputStreamReader(zipInputStream);
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            LinkedList<Message> linkedList = new LinkedList<Message>();
            while ((string = lineNumberReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
                if (!string.equals("</message>")) continue;
                try {
                    Message message = Message.parseString(stringBuffer.toString());
                    linkedList.add(message);
                }
                catch (MessageFormatException messageFormatException) {
                    CoreLogger.log("failed to parse message from archive: " + messageFormatException.getMessage(), 0);
                }
                stringBuffer = new StringBuffer();
            }
            CoreLogger.log("finished decompressing, " + linkedList.size() + " messages were found.", 2);
            return linkedList.toArray(new Message[linkedList.size()]);
        }
        catch (IOException iOException) {
            CoreLogger.log("Exception while creating archive: " + iOException.getClass().getName() + ": " + iOException.getMessage(), 0);
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private void insertMessages(Message[] messageArray) throws IOException {
        try {
            CoreLogger.log("compressing " + messageArray.length + " messages...", 2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("messages"));
            int n = 0;
            while (n < messageArray.length) {
                zipOutputStream.write(Message.getBytesFromString(messageArray[n].getString()));
                zipOutputStream.write(Message.getBytesFromString("\n"));
                ++n;
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.finish();
            this.compressedBytes = byteArrayOutputStream.toByteArray();
            CoreLogger.log("finished compressing, archive size is " + this.compressedBytes.length + " bytes.", 2);
        }
        catch (IOException iOException) {
            CoreLogger.log("cannot write to archive: " + iOException.getClass().getName() + ": " + iOException.getMessage(), 0);
            throw iOException;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "\u00e4\u00f6\u00fc\u00df\u00df\u00df\u00e1\u00e1\u00e0\u00e2'\u00c4\u00c4\u00c4\u00d6\u00d6\u00d6\u00dc\u00dc\u00dc$\u20ac";
            Message message = Message.parseString("<message type=\"post\" version=\"1.0\" originalUri=\"SSK@Y3mg8BkVZbh43ru0u4SVOHU866EPAgM/fmb/2002.03.19/0\" date=\"2002.03.19 13:37:34\" uniqueId=\"Y3mg8BkVZbh43ru0u4SVOHU866EPAgM10165450544120.37397355469723936\" source=\"SSK@Y3mg8BkVZbh43ru0u4SVOHU866EPAgM/fmb/2002.03.19/0\">\n\t<keywords></keywords>\n\t<replyTo></replyTo>\n\t<subject>\u00c4\u00e4\u00f6\u00fc\u00dc\u00d6\u00df\u00df\u00df\u00e1\u00e1\u00e0\u00e0\u00e2\u00e2\u00e2$\u00a7\u20ac</subject>\n\t<text></text>\n</message>");
            Message[] messageArray = new Message[]{message};
            MessageArchive messageArchive = new MessageArchive(messageArray, "test archive");
            Message[] messageArray2 = messageArchive.getMessages();
            if (!message.equals(messageArray2[0])) {
                // empty if block
            }
            System.err.println(messageArray2[0].getString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

