/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ArchiveMessage;
import freenetmessageboard.core.ChessMessage;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.MessageFormatException;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.NoSuchFieldException;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.PostCommentMessage;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import java.io.FileReader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class Message
implements Comparable {
    private String messageType;
    private String version = "1.0";
    private String originalUri = "n/a";
    private String date;
    private String uniqueId;
    private String sourceUri = "not succesfully inserted yet";
    protected static final int MSG_TYPE_USER = 0;
    protected static final int MSG_TYPE_USER_COMMENT = 1;
    protected static final int MSG_TYPE_POST = 2;
    protected static final int MSG_TYPE_POST_COMMENT = 3;
    protected static final int MSG_TYPE_ARCHIVE = 4;
    protected static final int MSG_TYPE_CHESS = 5;
    private int retrievedCounter;
    private int sentCounter;
    protected static String[] MSG_TYPE_TAGS = new String[]{"user", "userComment", "post", "postComment", "archive", "chess"};
    private static int nextId = 0;
    public static DateFormat messageDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private Map fields;
    private static Comparator dateComparator;
    private static Comparator reverseDateComparator;
    private static Comparator usefullForBroadcoastingComparator;

    void increaseRetrievedCounter() {
        ++this.retrievedCounter;
    }

    void increaseSentCounter() {
        ++this.sentCounter;
    }

    int getRetrievedCounter() {
        return this.retrievedCounter;
    }

    int getSentCounter() {
        return this.sentCounter;
    }

    protected Message(int n) {
        this.messageType = MSG_TYPE_TAGS[n];
        this.date = messageDateFormat.format(new Date());
        this.uniqueId = Message.generateUniqueID();
    }

    static String generateUniqueID() {
        String string = PersonalInfo.instance().getPublicKey();
        long l = System.currentTimeMillis();
        return string + l + nextId++;
    }

    public int compareTo(Object object) {
        Message message = (Message)object;
        return -this.date.compareTo(message.date);
    }

    protected Message(String string) throws MessageFormatException {
        if (!string.startsWith("<")) {
            throw new MessageFormatException("message doesn't start with <, no valid message");
        }
        try {
            String string2 = string.substring(1, string.indexOf(62));
            this.messageType = Message.getProperty(string2, "type");
            this.version = Message.getProperty(string2, "version");
            this.originalUri = Message.getProperty(string2, "originalUri");
            this.date = Message.getProperty(string2, "date");
            this.uniqueId = Message.getProperty(string2, "uniqueId");
            this.sourceUri = Message.getProperty(string2, "source");
            this.fields = Message.getFields(string, "message");
            if (!Message.isUriFromKey(this.originalUri, this.uniqueId.substring(0, 31))) {
                throw new MessageFormatException("the original uri doesn't contain the same public key as the msg id");
            }
        }
        catch (MessageFormatException messageFormatException) {
            throw messageFormatException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MessageFormatException(exception.getMessage());
        }
    }

    static boolean isUriFromKey(String string, String string2) {
        return string.startsWith("SSK@" + string2);
    }

    protected String getField(String string) throws NoSuchFieldException {
        String string2 = (String)this.fields.get(string);
        if (string2 == null) {
            throw new NoSuchFieldException(string);
        }
        return string2;
    }

    private static String filterStringForStrangeChars(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '<') {
                    stringBuffer.append(" lt ");
                } else if (c == '>') {
                    stringBuffer.append(" gt ");
                } else if (c == '\r') {
                    bl3 = true;
                    bl2 = false;
                    stringBuffer.append('\n');
                } else if (c == '\n' && !bl2) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        bl2 = true;
                        stringBuffer.append('\n');
                    }
                } else {
                    bl3 = false;
                    bl2 = false;
                    stringBuffer.append(c);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            CoreLogger.log("An exception occured " + throwable.getClass() + ": " + throwable.getMessage() + ":\n" + string + "\n", 0);
            throwable.printStackTrace();
            return new String();
        }
    }

    protected void setField(String string, String string2) {
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        this.fields.put(string, Message.filterStringForStrangeChars(string2));
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getOriginalUri() {
        return this.originalUri;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public String getSourceKey() {
        String string = this.getSourceUri();
        if (string.startsWith("KSK@")) {
            return string;
        }
        if (!string.startsWith("SSK@")) {
            return string;
        }
        return string.substring(4, 35);
    }

    public String getOriginalPublicKey() {
        CoreLogger.log("parsing " + this.uniqueId + " for the public key... ", 4);
        String string = this.uniqueId.substring(0, 31);
        CoreLogger.log("the public key of the message is " + string, 4);
        return string;
    }

    static Comparator getReverseDateComparator() {
        return reverseDateComparator;
    }

    static Comparator getDateComparator() {
        return dateComparator;
    }

    static Comparator getUsefulorBroadcoastingComparator() {
        return usefullForBroadcoastingComparator;
    }

    public void setOriginalUri(String string) {
        this.originalUri = string;
    }

    public Map getFields() {
        return this.fields;
    }

    public String getDate() {
        return this.date;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFromCurrentDay() {
        try {
            MessageGateway.instance();
            String string = MessageGateway.uriDateFormat.format(messageDateFormat.parse(this.date));
            String string2 = MessageGateway.uriDateFormat.format(MessageGateway.getCurrentDate());
            return string.equals(string2);
        }
        catch (Exception exception) {
            CoreLogger.log("Error while comparing the date of the message " + this.getUniqueId() + " to the current requesting day", 0);
            return false;
        }
    }

    public static String getStringFromBytes(byte[] byArray) {
        return new String(byArray);
    }

    public static byte[] getBytesFromString(String string) {
        return string.getBytes();
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer(400);
        try {
            stringBuffer.append(this.constructMessageTag());
            stringBuffer.append("\n");
            stringBuffer.append(Message.constructFieldTags(this.fields));
            stringBuffer.append("</message>");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            CoreLogger.log("exception while generating message string: " + exception.getClass().getName() + ": " + exception.getMessage(), 0);
            exception.printStackTrace();
            return new String();
        }
    }

    public boolean equals(Object object) {
        try {
            Message message = (Message)object;
            if (!this.headerEquals(message)) {
                return false;
            }
            return this.contentEquals(message);
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean contentEquals(Message message) {
        return this.fields.equals(message.fields);
    }

    boolean headerEquals(Message message) {
        if (!this.messageType.equals(message.messageType)) {
            return false;
        }
        if (!this.originalUri.equals(message.originalUri)) {
            return false;
        }
        if (!this.uniqueId.equals(message.uniqueId)) {
            return false;
        }
        return this.date.equals(message.date);
    }

    public static Message[] parseMultipleMessageString(String string) {
        CoreLogger.log("parsing multiple message string of " + string.length() + " bytes length", 4);
        try {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            int n2 = 0;
            ArrayList<Message> arrayList = new ArrayList<Message>();
            while ((n = string.indexOf("<message", n2)) != -1) {
                n2 = string.indexOf("</message>", n) + "</message".length() + 1;
                try {
                    String string2 = string.substring(n, n2);
                    Message message = Message.parseString(string2);
                    arrayList.add(message);
                }
                catch (MessageFormatException messageFormatException) {
                    CoreLogger.log("message format error while parsing a message: " + messageFormatException.getMessage(), 0);
                    throw messageFormatException;
                }
                catch (Throwable throwable) {
                    CoreLogger.log("exception while parsing a message: " + throwable.getClass().getName() + ": " + throwable.getMessage(), 0);
                    throw throwable;
                }
            }
            CoreLogger.log("found " + arrayList.size() + " messages in the multiple message string", 4);
            return arrayList.toArray(new Message[arrayList.size()]);
        }
        catch (Throwable throwable) {
            CoreLogger.log("exception while parsing a multiple message-string: " + throwable.getClass().getName() + ": " + throwable.getMessage(), 0);
            return new Message[0];
        }
    }

    public static Message parseString(String string) throws MessageFormatException {
        try {
            if (!string.startsWith("<")) {
                throw new MessageFormatException("message doesn't start with <, no valid message");
            }
            String string2 = string.substring(1, string.indexOf(62));
            try {
                String string3 = Message.getProperty(string2, "type");
                if (string3.equals(MSG_TYPE_TAGS[0])) {
                    return new UserMessage(string);
                }
                if (string3.equals(MSG_TYPE_TAGS[1])) {
                    return new UserCommentMessage(string);
                }
                if (string3.equals(MSG_TYPE_TAGS[2])) {
                    return new PostMessage(string);
                }
                if (string3.equals(MSG_TYPE_TAGS[3])) {
                    return new PostCommentMessage(string);
                }
                if (string3.equals(MSG_TYPE_TAGS[4])) {
                    return new ArchiveMessage(string);
                }
                if (string3.equals(MSG_TYPE_TAGS[5])) {
                    return new ChessMessage(string);
                }
                return new Message(string);
            }
            catch (Throwable throwable) {
                CoreLogger.log("There was an exception while parsing the message with the following header:\n" + string2, 0);
                CoreLogger.log("printing stack trace: ", 0);
                throwable.printStackTrace();
                throw new MessageFormatException(throwable.getMessage());
            }
        }
        catch (MessageFormatException messageFormatException) {
            throw messageFormatException;
        }
        catch (Throwable throwable) {
            CoreLogger.log("Unexpected exception while parsing message: " + throwable.getClass() + ": " + throwable.getMessage(), 0);
            throwable.printStackTrace();
            throw new MessageFormatException(throwable.getMessage());
        }
    }

    static Map getFields(String string, String string2) throws MessageFormatException {
        try {
            String string3 = Message.getContentOfTag(string, string2);
            StringReader stringReader = new StringReader(string3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            boolean bl = false;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            while (!bl) {
                ++n5;
                int n6 = stringReader.read();
                if (n6 == -1) break;
                char c = (char)n6;
                if (n == -1 && c == '<') {
                    n = n5;
                    continue;
                }
                if (n2 == -1 && c == '>') {
                    n2 = n5;
                    continue;
                }
                if (n3 == -1 && c == '<') {
                    n3 = n5;
                    continue;
                }
                if (n4 != -1 || c != '>') continue;
                n4 = n5;
                String string4 = string3.substring(n + 1, n2);
                String string5 = Message.filterStringForStrangeChars(string3.substring(n2 + 1, n3));
                hashMap.put(string4, string5);
                n = -1;
                n2 = -1;
                n3 = -1;
                n4 = -1;
            }
            return hashMap;
        }
        catch (MessageFormatException messageFormatException) {
            throw messageFormatException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MessageFormatException(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    private static String getContentOfTag(String string, String string2) throws MessageFormatException {
        try {
            int n = string.indexOf("<" + string2);
            int n2 = string.indexOf(62, n) + 1;
            int n3 = string.indexOf("</" + string2 + ">", n2);
            String string3 = string.substring(n2, n3).trim();
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MessageFormatException(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    public void setSource(String string) {
        this.sourceUri = string;
    }

    private String constructMessageTag() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("<message type=\"");
        stringBuffer.append(this.messageType);
        stringBuffer.append("\" ");
        stringBuffer.append("version=\"");
        stringBuffer.append(this.version);
        stringBuffer.append("\" originalUri=\"");
        stringBuffer.append(this.originalUri);
        stringBuffer.append("\" date=\"");
        stringBuffer.append(this.date);
        stringBuffer.append("\" uniqueId=\"");
        stringBuffer.append(this.uniqueId);
        stringBuffer.append("\" source=\"");
        stringBuffer.append(this.sourceUri);
        stringBuffer.append("\">");
        return stringBuffer.toString();
    }

    static String constructFieldTags(Map map) {
        StringBuffer stringBuffer = new StringBuffer(200);
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            stringBuffer.append("\t<");
            stringBuffer.append(string);
            stringBuffer.append('>');
            stringBuffer.append(string2);
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">\n");
        }
        return stringBuffer.toString();
    }

    private static String getProperty(String string, String string2) throws MessageFormatException {
        try {
            int n = string.indexOf(string2 + "=");
            int n2 = string.indexOf(34, n) + 1;
            int n3 = string.indexOf(34, n2);
            String string3 = string.substring(n2, n3);
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MessageFormatException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        PersonalInfo.instance();
    }

    public String toShortString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    private static String readStringFromFile(String string) {
        try {
            char[] cArray;
            int n;
            FileReader fileReader = new FileReader(string);
            StringBuffer stringBuffer = new StringBuffer(400);
            while ((n = fileReader.read(cArray = new char[100])) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println(string + ": failed to read: " + exception.getMessage());
            return new String();
        }
    }

    static {
        messageDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                Message message = (Message)object;
                Message message2 = (Message)object2;
                return message.date.compareTo(message2.date);
            }
        };
        reverseDateComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                Message message = (Message)object;
                Message message2 = (Message)object2;
                return -message.date.compareTo(message2.date);
            }
        };
        usefullForBroadcoastingComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    Message message = (Message)object;
                    Message message2 = (Message)object2;
                    long l = messageDateFormat.parse(message.getDate()).getTime();
                    long l2 = messageDateFormat.parse(message2.getDate()).getTime();
                    long l3 = 3600000L;
                    long l4 = l - (long)message.getRetrievedCounter() * l3 - (long)message.getSentCounter() * l3 * 3L;
                    long l5 = l2 - (long)message2.getRetrievedCounter() * l3 - (long)message2.getSentCounter() * l3 * 3L;
                    if (l4 > l5) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception exception) {
                    CoreLogger.log("Exception while comparing messages: " + exception.getClass().getName() + ": " + exception.getMessage(), 0);
                    exception.printStackTrace();
                    return 0;
                }
            }
        };
    }
}

