/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArrivedListener;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.PersonalInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ForwardDemon
extends Thread
implements MessageArrivedListener {
    private HashSet requestedChannels = new HashSet();
    private List newMessagesList = new LinkedList();
    private HashMap forwardedMessages = new HashMap();

    public ForwardDemon() {
        MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getAcceptAllMessageFilter());
    }

    public void messageArrived(Message message) {
        CoreLogger.log("received " + message.toShortString() + " from " + message.getSourceUri(), 1);
        if (message.getSourceKey().equals(PersonalInfo.instance().getPublicKey())) {
            return;
        }
        List list = this.newMessagesList;
        synchronized (list) {
            this.newMessagesList.add(message);
        }
    }

    private void processNewMessages() {
        List list = this.newMessagesList;
        synchronized (list) {
            Iterator iterator = this.newMessagesList.iterator();
            while (iterator.hasNext()) {
                Comparable<Date> comparable;
                Message message = (Message)iterator.next();
                iterator.remove();
                if (!this.requestedChannels.contains(message.getOriginalPublicKey())) {
                    try {
                        comparable = Message.messageDateFormat.parse(message.getDate());
                        if (MessageGateway.uriDateFormat.format((Date)comparable).equals(MessageGateway.uriDateFormat.format(MessageGateway.getCurrentDate()))) {
                            CoreLogger.log("received first recent message from user " + message.getOriginalPublicKey() + ", start requesting channel...", 1);
                            MessageGateway.instance().startListeningOnPersonalChannel(message.getOriginalPublicKey());
                            this.requestedChannels.add(message.getOriginalPublicKey());
                        }
                    }
                    catch (Exception exception) {
                        CoreLogger.log("failed to parse the date from message " + message.toShortString(), 0);
                    }
                }
                if (!this.forwardedMessages.containsKey(message.getUniqueId())) {
                    this.forwardedMessages.put(message.getUniqueId(), message);
                    CoreLogger.log("fowarding " + message.toShortString() + " from " + message.getOriginalPublicKey() + "...", 1);
                    MessageGateway.instance().sendMessageOnPersonalChannel(message);
                    continue;
                }
                comparable = (Message)this.forwardedMessages.get(message.getUniqueId());
                if (((Message)comparable).equals(message) || !message.getOriginalPublicKey().equals(message.getSourceKey())) continue;
                CoreLogger.log("fowarding " + message.toShortString() + " from " + message.getOriginalPublicKey() + "...", 1);
                MessageGateway.instance().sendMessageOnPersonalChannel(message);
            }
        }
    }

    public void run() {
        Message[] messageArray = MessagePool.instance().getUsefulMessages();
        int n = 0;
        while (n < messageArray.length) {
            CoreLogger.log("fowarding " + messageArray[n].toShortString() + " from local message pool, because I think it is useful...", 1);
            MessageGateway.instance().sendMessageOnPersonalChannel(messageArray[n]);
            ++n;
        }
        MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
        int n2 = 0;
        while (true) {
            this.processNewMessages();
            if (n2 % 5 == 0 || CoreLogger.logLevel >= 2) {
                CoreLogger.log("the forward demon is listening to " + this.requestedChannels.size() + " channels, has " + MessageGateway.instance().getActiveInsertCount() + " active inserts and " + MessageGateway.instance().getSendBufferSize() + " bytes buffered, next slot is " + MessageGateway.instance().getSlotInfoStringForMyPersonalChannel().length(), 1);
            }
            ++n2;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
    }

    class ForwardInfo {
        int sentCount;
        int receivedCount;

        ForwardInfo() {
        }
    }
}

