/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.Main;
import freenetmessageboard.core.ContactInformation;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FMBSettings;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArrivedListener;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessageNotReceivedException;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.NoSuchContactException;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ContactList
implements MessageArrivedListener {
    private static ContactList instance;
    private Map contactInformations = new HashMap();

    private ContactList() {
        MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getUserMessagesAndCommentsOnlyFilter());
    }

    public static synchronized ContactList instance() {
        if (instance == null) {
            instance = new ContactList();
        }
        return instance;
    }

    private void userMessageArrived(final UserMessage userMessage) {
        Object object;
        CoreLogger.log("the contact list received an announcement from " + userMessage.getNickName(), 2);
        if (userMessage.isFromCurrentDay() && FMBSettings.instance().autoListen && !MessageGateway.instance().isListeningOnPersonalChannel(userMessage.getPublicKey())) {
            object = new Thread("auto listener thread"){

                public void run() {
                    CoreLogger.log("automatic listening for " + userMessage.getNickName() + "'s channel is starting...", 1);
                    MessageGateway.instance().startListeningOnPersonalChannel(userMessage.getPublicKey());
                }
            };
            ((Thread)object).start();
        }
        if (((String)(object = userMessage.getSourceKey())).equals(userMessage.getPublicKey())) {
            CoreLogger.log("this announcement is an original version because was received from " + (String)object, 2);
        } else {
            CoreLogger.log("this announcement is only a copy from " + (String)object, 2);
        }
        if (this.contactInformations.containsKey(userMessage.getPublicKey())) {
            ContactInformation contactInformation = (ContactInformation)this.contactInformations.get(userMessage.getPublicKey());
            contactInformation.addUserMessage(userMessage);
            Main.getGUI().updateContactPanel(userMessage.getPublicKey());
        } else {
            ContactInformation contactInformation = new ContactInformation(userMessage);
            if (!userMessage.getPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
                // empty if block
            }
            this.contactInformations.put(userMessage.getPublicKey(), contactInformation);
            Main.getGUI().addContactPanel(contactInformation);
        }
    }

    public UserMessage getLatestUserMessageFromPublicKey(String string) throws MessageNotReceivedException {
        ContactInformation contactInformation = (ContactInformation)this.contactInformations.get(string);
        if (contactInformation == null) {
            CoreLogger.log("requested a user message from an unknown user: " + string, 0);
            throw new MessageNotReceivedException();
        }
        return contactInformation.getLastUserMessage();
    }

    public UserMessage[] getUserMessagesToBeAnnounced() {
        LinkedList<UserMessage> linkedList = new LinkedList<UserMessage>();
        Map map = this.contactInformations;
        synchronized (map) {
            Iterator iterator = this.contactInformations.values().iterator();
            while (iterator.hasNext()) {
                ContactInformation contactInformation = (ContactInformation)iterator.next();
                if (contactInformation.getPublicKey().equals(PersonalInfo.instance().getPublicKey())) continue;
                linkedList.add(contactInformation.getLastUserMessage());
            }
            Collections.sort(linkedList, Message.getReverseDateComparator());
            if (linkedList.size() > 9) {
                int n = linkedList.size() - 1;
                while (n > 8) {
                    linkedList.remove(n);
                    --n;
                }
            }
            linkedList.add(PersonalInfo.instance().createUserMessage());
        }
        return linkedList.toArray(new UserMessage[linkedList.size()]);
    }

    private void userCommentMessageArrived(UserCommentMessage userCommentMessage) {
        CoreLogger.log("the contact list received a comment on " + userCommentMessage.getUserPublicKey(), 2);
        String string = userCommentMessage.getSourceKey();
        if (userCommentMessage.getUserPublicKey().equals(userCommentMessage.getOriginalPublicKey())) {
            return;
        }
        if (string.equals(userCommentMessage.getOriginalPublicKey())) {
            CoreLogger.log("this user comment is an original version because it was received from " + string, 2);
        } else {
            CoreLogger.log("this user comment is only a copy from " + string, 2);
        }
        if (this.contactInformations.containsKey(userCommentMessage.getUserPublicKey())) {
            ContactInformation contactInformation = (ContactInformation)this.contactInformations.get(userCommentMessage.getUserPublicKey());
            contactInformation.addUserCommentMessage(userCommentMessage);
        }
    }

    public ContactInformation getContactInformationOfPublicKey(String string) throws NoSuchContactException {
        ContactInformation contactInformation = (ContactInformation)this.contactInformations.get(string);
        if (contactInformation == null) {
            throw new NoSuchContactException();
        }
        return contactInformation;
    }

    public String getNicknameOfPublicKey(String string) {
        ContactInformation contactInformation = (ContactInformation)this.contactInformations.get(string);
        if (contactInformation == null) {
            if (string.startsWith("KSK@")) {
                return "anyone";
            }
            if (string.equals("not succesfully inserted yet")) {
                return "memory";
            }
            return "unknown user";
        }
        return contactInformation.getNickname();
    }

    public void messageArrived(Message message) {
        if (message instanceof UserMessage) {
            this.userMessageArrived((UserMessage)message);
        }
        if (message instanceof UserCommentMessage) {
            this.userCommentMessageArrived((UserCommentMessage)message);
        }
    }

    public static void main(String[] stringArray) {
        ContactList.instance();
    }
}

