/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.Main;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContactInformation {
    private List userMessages = new LinkedList();
    private Map userCommentMessages = new HashMap();
    private int goodRatings = 0;
    private int neutralRatings = 0;
    private int evilRatings = 0;
    private static int maxRatings = 0;
    private long timeOfLastActivity;

    public ContactInformation(UserMessage userMessage) {
        this.addUserMessage(userMessage);
        this.setTimeOfLastActivity(userMessage.getDate());
    }

    public long getTimeOfLastActivity() {
        return this.timeOfLastActivity;
    }

    public int[] getRatings() {
        int n = maxRatings - (this.goodRatings + this.neutralRatings + this.evilRatings);
        return new int[]{this.goodRatings, this.neutralRatings, this.evilRatings, n};
    }

    public int getRatingScore() {
        return this.goodRatings * 3 + this.neutralRatings * 2 + this.evilRatings;
    }

    void setTimeOfLastActivity(String string) {
        try {
            long l = Message.messageDateFormat.parse(string).getTime();
            if (l > this.timeOfLastActivity) {
                this.timeOfLastActivity = l;
                Main.getGUI().updateContactPanel(this.getPublicKey());
            }
        }
        catch (ParseException parseException) {
            CoreLogger.log("couldn't parse the date from " + string, 0);
        }
    }

    void addUserMessage(UserMessage userMessage) {
        List list = this.userMessages;
        synchronized (list) {
            if (!this.userMessages.contains(userMessage)) {
                this.userMessages.add(userMessage);
                Collections.sort(this.userMessages, Message.getReverseDateComparator());
                this.setTimeOfLastActivity(userMessage.getDate());
            } else {
                UserMessage userMessage2 = (UserMessage)this.userMessages.get(this.userMessages.indexOf(userMessage));
                if (userMessage.getSourceUri().equals(userMessage.getOriginalUri()) || userMessage2.getSourceUri().indexOf("SK@") == -1) {
                    this.userMessages.remove(userMessage2);
                    this.userMessages.add(userMessage);
                    Collections.sort(this.userMessages, Message.getReverseDateComparator());
                    this.setTimeOfLastActivity(userMessage.getDate());
                }
            }
        }
    }

    void increaseRatingCounter(String string) {
        if (string.equals("GOOD")) {
            ++this.goodRatings;
        }
        if (string.equals("NEUTRAL")) {
            ++this.neutralRatings;
        }
        if (string.equals("EVIL")) {
            ++this.evilRatings;
        }
        if (this.goodRatings + this.neutralRatings + this.evilRatings > maxRatings) {
            maxRatings = this.goodRatings + this.neutralRatings + this.evilRatings;
        }
    }

    void decreaseRatingCounter(String string) {
        if (string.equals("GOOD")) {
            --this.goodRatings;
        }
        if (string.equals("NEUTRAL")) {
            --this.neutralRatings;
        }
        if (string.equals("EVIL")) {
            --this.evilRatings;
        }
    }

    void addUserCommentMessage(UserCommentMessage userCommentMessage) {
        if (!this.userCommentMessages.containsKey(userCommentMessage.getOriginalPublicKey())) {
            this.userCommentMessages.put(userCommentMessage.getOriginalPublicKey(), userCommentMessage);
            this.increaseRatingCounter(userCommentMessage.getRating());
        } else {
            UserCommentMessage userCommentMessage2 = (UserCommentMessage)this.userCommentMessages.get(userCommentMessage.getOriginalPublicKey());
            if (userCommentMessage.compareTo(userCommentMessage2) < 0 || userCommentMessage.getSourceUri().equals(userCommentMessage.getOriginalUri())) {
                this.decreaseRatingCounter(userCommentMessage2.getRating());
                this.userCommentMessages.put(userCommentMessage.getOriginalPublicKey(), userCommentMessage);
                this.increaseRatingCounter(userCommentMessage.getRating());
            }
        }
    }

    public String getName() {
        return this.getLastUserMessage().getName();
    }

    public String getInterests() {
        return this.getLastUserMessage().getInterests();
    }

    public String getFreesiteUri() {
        return this.getLastUserMessage().getFreesiteUri();
    }

    public String getNickname() {
        return this.getLastUserMessage().getNickName();
    }

    public String getPublicKey() {
        return this.getLastUserMessage().getPublicKey();
    }

    public UserCommentMessage[] getUserCommentMessages() {
        return this.userCommentMessages.values().toArray(new UserCommentMessage[this.userCommentMessages.size()]);
    }

    public UserMessage[] getUserMessages() {
        return this.userMessages.toArray(new UserMessage[this.userMessages.size()]);
    }

    public UserMessage getLastUserMessage() {
        return (UserMessage)this.userMessages.get(0);
    }
}

