/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageFormatException;
import freenetmessageboard.core.NoSuchFieldException;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.schach.SchachSpiel;

public class ChessMessage
extends Message {
    private String whitePublicKey = new String();
    private String blackPublicKey = new String();
    private String movesString = new String();
    private String whiteMessage = new String();
    private String blackMessage = new String();
    private String gameID = new String();
    private String beginningDate = new String();
    private String moveCount = new String("0");

    public ChessMessage(SchachSpiel schachSpiel) {
        super(5);
        this.whitePublicKey = schachSpiel.getWhitePublicKey();
        this.blackPublicKey = schachSpiel.getBlackPublicKey();
        this.movesString = schachSpiel.getMovesString();
        this.gameID = schachSpiel.getGameId();
        this.beginningDate = schachSpiel.getBeginningDate();
        this.whiteMessage = schachSpiel.getWhiteMessage();
        this.blackMessage = schachSpiel.getBlackMessage();
        this.moveCount = Integer.toString(schachSpiel.getMoveCount());
        super.setField("white", this.whitePublicKey);
        super.setField("black", this.blackPublicKey);
        super.setField("moves", this.movesString);
        super.setField("moveCount", this.moveCount);
        super.setField("whiteMessage", this.whiteMessage);
        super.setField("blackMessage", this.blackMessage);
        super.setField("gameId", this.gameID);
        super.setField("beginning", this.beginningDate);
    }

    public ChessMessage() {
        super(5);
        this.blackPublicKey = PersonalInfo.instance().getPublicKey();
        super.setField("white", this.whitePublicKey);
        super.setField("black", this.blackPublicKey);
        super.setField("moves", this.movesString);
        super.setField("moveCount", this.moveCount);
        super.setField("whiteMessage", this.whiteMessage);
        super.setField("blackMessage", this.blackMessage);
        super.setField("gameId", this.gameID);
        super.setField("beginning", this.beginningDate);
    }

    public ChessMessage(String string) throws MessageFormatException {
        super(string);
        try {
            this.whitePublicKey = super.getField("white");
            this.blackPublicKey = super.getField("black");
            this.movesString = super.getField("moves");
            this.whiteMessage = super.getField("whiteMessage");
            this.blackMessage = super.getField("blackMessage");
            this.gameID = super.getField("gameId");
            this.beginningDate = super.getField("beginning");
            this.moveCount = super.getField("moveCount");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new MessageFormatException(noSuchFieldException.getMessage());
        }
    }

    public String getWhiteKey() {
        return this.whitePublicKey;
    }

    public String getBlackKey() {
        return this.blackPublicKey;
    }

    public String toString() {
        return ContactList.instance().getNicknameOfPublicKey(this.blackPublicKey);
    }

    public String getGameId() {
        return this.gameID;
    }

    public String getBeginningDate() {
        return this.beginningDate;
    }

    public String getMovesString() {
        return this.movesString;
    }

    public String getMovesSoFar() {
        return this.moveCount;
    }

    public SchachSpiel getSchachSpiel() {
        SchachSpiel schachSpiel = new SchachSpiel(this.gameID, this.beginningDate, this.whitePublicKey, this.blackPublicKey, this.whiteMessage, this.blackMessage);
        schachSpiel.doMoves(this.movesString);
        return schachSpiel;
    }
}

