/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ChessMessage;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArrivedListener;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.SchachTestFrame;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public class ChessLounge
extends AbstractTableModel
implements Runnable,
MessageArrivedListener,
ComboBoxModel {
    private static ChessLounge instance;
    private List opponentList = new LinkedList();
    private List newMessagesList = new LinkedList();
    private HashMap chessMessagesMap = new HashMap();
    private List allGameIds = new LinkedList();
    private List listDataListenerList = new LinkedList();
    private String[] colNames = new String[]{"white", "black", "last move at", "moves", "beginning"};
    private boolean informMeWhenItsMyTurn = false;
    private ChessMessage selectedOpponentMessage;

    private ChessLounge() {
        MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getChessMessagesOnlyFilter());
    }

    public void informMeWhenItsMyTurn(boolean bl) {
        if (!bl) {
            this.informMeWhenItsMyTurn = false;
            return;
        }
        CoreLogger.log("processing messages from local hard disk..", 2);
        this.processNewMessages();
        CoreLogger.log("looking for active games waiting for my turn...", 2);
        this.informMeWhenItsMyTurn = true;
        List list = this.allGameIds;
        synchronized (list) {
            Iterator iterator = this.allGameIds.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CoreLogger.log("found " + string, 2);
                ChessMessage chessMessage = (ChessMessage)this.chessMessagesMap.get(string);
                this.displayIfNeccessary(chessMessage);
            }
        }
        CoreLogger.log("starting thread to listen for processing new messages...", 2);
    }

    public Object getSelectedItem() {
        if (this.selectedOpponentMessage != null) {
            return this.selectedOpponentMessage;
        }
        return "select opponent...";
    }

    public void setSelectedItem(Object object) {
        this.selectedOpponentMessage = object instanceof ChessMessage ? (ChessMessage)object : null;
    }

    public int getSize() {
        return this.opponentList.size() + 1;
    }

    public Object getElementAt(int n) {
        if (n == 0) {
            return "select opponent...";
        }
        return this.opponentList.get(n - 1);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataListenerList.add(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataListenerList.remove(listDataListener);
    }

    public static ChessLounge instance() {
        if (instance == null) {
            instance = new ChessLounge();
            ChessLounge.instance().start();
        }
        return instance;
    }

    private void fireNewOpponent() {
        Iterator iterator = this.listDataListenerList.iterator();
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, this.opponentList.size(), this.opponentList.size());
        while (iterator.hasNext()) {
            ListDataListener listDataListener = (ListDataListener)iterator.next();
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    private void fireNewGame() {
        super.fireTableRowsInserted(this.allGameIds.size() - 1, this.allGameIds.size() - 1);
    }

    private void fireGameChanged(String string) {
        int n = this.allGameIds.indexOf(string);
        super.fireTableRowsUpdated(n, n);
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public void showGame(int n) {
        String string = (String)this.allGameIds.get(n);
        ChessMessage chessMessage = (ChessMessage)this.chessMessagesMap.get(string);
        SchachTestFrame schachTestFrame = new SchachTestFrame(chessMessage.getSchachSpiel());
    }

    public int getRowCount() {
        return this.allGameIds.size();
    }

    public Object getValueAt(int n, int n2) {
        String string = (String)this.allGameIds.get(n);
        ChessMessage chessMessage = (ChessMessage)this.chessMessagesMap.get(string);
        switch (n2) {
            case 0: {
                return ContactList.instance().getNicknameOfPublicKey(chessMessage.getWhiteKey());
            }
            case 1: {
                return ContactList.instance().getNicknameOfPublicKey(chessMessage.getBlackKey());
            }
            case 2: {
                return chessMessage.getDate();
            }
            case 3: {
                return chessMessage.getMovesSoFar();
            }
            case 4: {
                return chessMessage.getBeginningDate();
            }
        }
        return "";
    }

    private void displayIfNeccessary(ChessMessage chessMessage) {
        if (!this.informMeWhenItsMyTurn) {
            CoreLogger.log("won't display begause displaying is turned off", 2);
            return;
        }
        if (!chessMessage.getBlackKey().equals(PersonalInfo.instance().getPublicKey()) && !chessMessage.getWhiteKey().equals(PersonalInfo.instance().getPublicKey())) {
            CoreLogger.log("won't display because I am neither black nor white", 2);
            return;
        }
        SchachSpiel schachSpiel = chessMessage.getSchachSpiel();
        if (!schachSpiel.binIchAmZug()) {
            CoreLogger.log("won't display because it's not my move", 2);
            return;
        }
        CoreLogger.log("i'm gonna show it", 2);
        SchachTestFrame schachTestFrame = new SchachTestFrame(schachSpiel);
    }

    public void processNewMessages() {
        List list = this.newMessagesList;
        synchronized (list) {
            Iterator iterator = this.newMessagesList.iterator();
            while (iterator.hasNext()) {
                ChessMessage chessMessage = (ChessMessage)iterator.next();
                if (chessMessage.getGameId().length() == 0) {
                    CoreLogger.log("processing chess announcement from " + chessMessage.getOriginalPublicKey(), 2);
                    boolean bl = false;
                    Iterator iterator2 = this.opponentList.iterator();
                    while (iterator2.hasNext()) {
                        ChessMessage chessMessage2 = (ChessMessage)iterator2.next();
                        if (!chessMessage2.getBlackKey().equals(chessMessage.getBlackKey())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        CoreLogger.log("adding " + chessMessage.getOriginalPublicKey() + " to the list of opponents", 2);
                        this.opponentList.add(chessMessage);
                        this.fireNewOpponent();
                    } else {
                        CoreLogger.log("ignoring " + chessMessage.getOriginalPublicKey() + "he is already in the list", 2);
                    }
                } else {
                    CoreLogger.log("received gamestate for game " + chessMessage.getGameId(), 2);
                    if (!this.chessMessagesMap.containsKey(chessMessage.getGameId())) {
                        CoreLogger.log("its a new game, add it to the table", 2);
                        this.chessMessagesMap.put(chessMessage.getGameId(), chessMessage);
                        this.allGameIds.add(chessMessage.getGameId());
                        this.fireNewGame();
                        this.displayIfNeccessary(chessMessage);
                    } else {
                        ChessMessage chessMessage3 = (ChessMessage)this.chessMessagesMap.get(chessMessage.getGameId());
                        if (chessMessage.getDate().compareTo(chessMessage3.getDate()) > 0) {
                            CoreLogger.log("it is a new gamestate, updating the table", 2);
                            if (!chessMessage.getMovesString().startsWith(chessMessage3.getMovesString())) {
                                CoreLogger.log("ignoring the new gamestate because it doesn't start with the same move as the old one!", 0);
                            } else {
                                this.chessMessagesMap.put(chessMessage.getGameId(), chessMessage);
                                this.fireGameChanged(chessMessage.getGameId());
                                this.displayIfNeccessary(chessMessage);
                            }
                        } else {
                            CoreLogger.log("ignore it, it is an old gamestate", 2);
                        }
                    }
                }
                iterator.remove();
            }
        }
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, "chess lounge");
        thread.start();
    }

    public void run() {
        while (true) {
            this.processNewMessages();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void messageArrived(Message message) {
        CoreLogger.log("a new chess message arrived: " + message.toShortString(), 2);
        List list = this.newMessagesList;
        synchronized (list) {
            this.newMessagesList.add(message);
        }
    }
}

