/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.Main;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FreenetNetworkSettings;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.PersonalInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ChannelInfo {
    String baseName;
    private List receivedIndexList = new LinkedList();
    private List numberOfRetriesList = new LinkedList();
    private int currentIndex;
    private int currentHtl;
    private boolean[] receivedIndex = new boolean[10];
    private boolean[] indexMustBeThere = new boolean[10];
    private int[] triedIndex = new int[10];
    private boolean isListening;
    private String statusString = "not listening on this channel";
    private String slotInfoString = "";
    private static HashMap allInfos = new HashMap();

    private ChannelInfo(String string) {
        this.baseName = string;
        if (Message.isUriFromKey(string, PersonalInfo.instance().getPublicKey())) {
            this.statusString = "this is you";
        }
    }

    void startedListening(String string) {
        this.statusString = string;
        this.isListening = true;
    }

    public static ChannelInfo getInstance(String string) {
        ChannelInfo channelInfo = (ChannelInfo)allInfos.get(string);
        if (channelInfo == null) {
            channelInfo = new ChannelInfo(string);
            allInfos.put(string, channelInfo);
        }
        return channelInfo;
    }

    public static boolean instanceExists(String string) {
        return allInfos.containsKey(string);
    }

    int getHTLForCurrentRequest() {
        int n = FreenetNetworkSettings.instance().channelRequestHTL + this.getRetryCountOfIndex(this.currentIndex) * FreenetNetworkSettings.instance().channelRequestHTLIncrease;
        return n;
    }

    String getNextUri() {
        return this.baseName + this.getNextIndex();
    }

    int getCurrentSlot() {
        return this.currentIndex;
    }

    synchronized int getRetryCountOfIndex(int n) {
        if (n > this.receivedIndex.length) {
            this.increaseArrayBounds(n + 10);
        }
        return this.triedIndex[n];
    }

    public synchronized String getStatusString() {
        CoreLogger.log("the status string of channel " + this.baseName + " is " + this.statusString, 4);
        return this.statusString;
    }

    public synchronized String getSlotInfoString() {
        if (this.slotInfoString.length() > 30) {
            return "..." + this.slotInfoString.substring(this.slotInfoString.length() - 30);
        }
        return this.slotInfoString;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void updateSlotInfoString() {
        var1_1 = new StringBuffer(40);
        var2_2 = false;
        var3_3 = MessageGateway.instance().getCurrentPublicAnnouncementInsertIndex();
        if (var3_3 != -1) {
            CoreLogger.log("I am currently announcing on slot " + var3_3, 2);
            var2_2 = true;
        }
        var4_4 = 0;
        while (var4_4 < this.triedIndex.length) {
            block11: {
                block10: {
                    var5_5 = this.baseName + var4_4;
                    if (!MessageGateway.instance().isUriSpammed(var5_5)) break block10;
                    var1_1.append('?');
                    break block11;
                }
                if (!var2_2) ** GOTO lbl-1000
                MessageGateway.instance();
                if (this.baseName.equals(MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate())) && var4_4 == var3_3) {
                    var1_1.append('I');
                } else if (this.currentIndex == var4_4) {
                    var1_1.append('R');
                } else if (this.receivedIndex[var4_4]) {
                    var1_1.append('X');
                } else {
                    var6_6 = true;
                    var7_7 = var4_4;
                    while (var7_7 < this.triedIndex.length) {
                        if (this.triedIndex[var7_7] > 0 || this.receivedIndex[var7_7] || this.indexMustBeThere[var7_7]) {
                            var6_6 = false;
                        }
                        ++var7_7;
                    }
                    if (var6_6) break;
                    var8_8 = Integer.toString(this.triedIndex[var4_4]);
                    var1_1.append(var8_8.charAt(var8_8.length() - 1));
                }
            }
            ++var4_4;
        }
        this.slotInfoString = var1_1.toString();
    }

    synchronized void setStatusString(String string) {
        CoreLogger.log("setting status string of channel " + this.baseName + " to " + string, 4);
        this.statusString = string;
        this.updateSlotInfoString();
        if (this.baseName.startsWith("SSK@")) {
            String string2 = this.baseName.substring(4, 35);
            CoreLogger.log("updating channel status on contact list...", 4);
            Main.getGUI().updateContactPanel(string2);
        }
        MessageGateway.instance();
        if (this.baseName.equals(MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) {
            Main.getGUI().setAnnouncementChannelStatusString(this.statusString, this.getSlotInfoString());
        }
    }

    private synchronized int getNextIndex() {
        CoreLogger.log("calculating which slot to request next from channel " + this.baseName, 4);
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.receivedIndex.length) {
            if (this.isIndexReceived(n3)) {
                n = n3;
            } else if (this.indexMustBeThere[n3]) {
                n2 = n3;
            }
            ++n3;
        }
        CoreLogger.log("last index that was received: " + n, 4);
        CoreLogger.log("last index I heard of: " + n2, 4);
        if (n2 != -1) {
            if (this.triedIndex[n2] < 2) {
                this.currentIndex = n2;
                CoreLogger.log("try the last index i heard of: " + n2, 4);
                return this.currentIndex;
            }
            CoreLogger.log("DON'T try the last index i heard of: " + n2 + ", tried " + this.triedIndex[n2] + " times before", 4);
        }
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.receivedIndex.length) {
            if (!this.isIndexReceived(n5)) {
                if (n4 == -1) {
                    n4 = n5;
                }
                if (n5 > n + 3 && n5 > n2) {
                    CoreLogger.log("try index " + n4 + ", there were no message after " + n, 4);
                    this.currentIndex = n4;
                    return this.currentIndex;
                }
                if (this.triedIndex[n5] < this.triedIndex[n4]) {
                    CoreLogger.log("maybe index " + n5 + ", we've tried it only " + this.triedIndex[n5] + " times.", 4);
                    n4 = n5;
                } else {
                    CoreLogger.log("don't try index " + n5 + ", we've tried it " + this.triedIndex[n5] + " times.", 4);
                }
            }
            ++n5;
        }
        int n6 = this.receivedIndex.length;
        this.increaseArrayBounds(n6 + 10);
        this.currentIndex = n6;
        return n6;
    }

    private synchronized int getNextIndexOld() {
        CoreLogger.log("calculating which slot to request next from channel " + this.baseName, 4);
        int n = -1;
        int n2 = -1;
        int n3 = 99;
        int n4 = 0;
        while (n4 < this.receivedIndex.length) {
            if (!this.isIndexReceived(n4)) {
                CoreLogger.log("slot " + n4 + " has not been received yet...", 4);
                if (n != -1 && this.triedIndex[n4] > n3 - (n4 - n) + 4 && this.triedIndex[n4] < 9) {
                    CoreLogger.log("try slot " + n + " (" + n3 + "), before trying slot " + n4 + " (" + this.triedIndex[n4] + " retries).", 4);
                    this.currentIndex = n;
                    return n;
                }
                if (this.triedIndex[n4] < n3) {
                    CoreLogger.log("slot " + n4 + " looks good, because you only have tried it " + this.triedIndex[n4] + " times...", 4);
                    n = n4;
                    n3 = this.triedIndex[n4];
                }
            } else {
                n2 = n4;
            }
            if (n4 - n2 >= 3) {
                CoreLogger.log("try slot " + n + ", there was no other message found up to slot " + n4, 4);
                this.currentIndex = n;
                return n;
            }
            ++n4;
        }
        int n5 = this.receivedIndex.length;
        this.increaseArrayBounds(this.receivedIndex.length + 10);
        CoreLogger.log("increased array bounds to create slot " + n5, 4);
        this.currentIndex = n5;
        return n5;
    }

    synchronized boolean isIndexReceived(int n) {
        if (n >= this.receivedIndex.length) {
            return false;
        }
        return this.receivedIndex[n];
    }

    private synchronized void increaseArrayBounds(int n) {
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = n2 < this.receivedIndex.length ? this.receivedIndex[n2] : false;
            ++n2;
        }
        this.receivedIndex = blArray;
        boolean[] blArray2 = new boolean[n];
        int n3 = 0;
        while (n3 < blArray2.length) {
            blArray2[n3] = n3 < this.indexMustBeThere.length ? this.indexMustBeThere[n3] : false;
            ++n3;
        }
        this.indexMustBeThere = blArray2;
        int[] nArray = new int[n];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = n4 < this.triedIndex.length ? this.triedIndex[n4] : 0;
            ++n4;
        }
        this.triedIndex = nArray;
    }

    synchronized void heardOfIndex(int n) {
        if (n >= this.receivedIndex.length) {
            this.increaseArrayBounds(n + 10);
        }
        this.indexMustBeThere[n] = true;
    }

    synchronized void failedToReceiveIndex(int n) {
        if (n >= this.receivedIndex.length) {
            this.increaseArrayBounds(n + 10);
        }
        int n2 = n;
        this.triedIndex[n2] = this.triedIndex[n2] + 1;
    }

    synchronized void receivedIndex(int n) {
        if (n >= this.receivedIndex.length) {
            this.increaseArrayBounds(n + 10);
        }
        this.receivedIndex[n] = true;
    }
}

