/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArchive;
import freenetmessageboard.core.MessageFormatException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;

public class ArchiveMessage
extends Message {
    private String uri;
    private String messageListingString;
    private int size;
    private String description;

    public ArchiveMessage(String string, MessageArchive messageArchive) {
        super(4);
        this.uri = string;
        this.messageListingString = messageArchive.getMessageListing();
        this.size = messageArchive.getBytes().length;
        this.description = messageArchive.getDescription();
        super.setField("uri", this.uri);
        super.setField("messageListing", this.messageListingString);
        super.setField("description", this.description);
        super.setField("size", Integer.toString(this.size));
    }

    public ArchiveMessage(String string) throws MessageFormatException {
        super(string);
        try {
            this.uri = super.getField("uri");
            this.messageListingString = super.getField("messageListing");
            this.description = super.getField("description");
            this.size = Integer.parseInt(super.getField("size"));
        }
        catch (Throwable throwable) {
            throw new MessageFormatException(throwable.getClass() + ": " + throwable.getMessage());
        }
    }

    String getUri() {
        return this.uri;
    }

    String getDescription() {
        return this.description;
    }

    int getSize() {
        return this.size;
    }

    String[] getUniqueIDs() {
        try {
            StringReader stringReader = new StringReader(this.messageListingString);
            LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = lineNumberReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = lineNumberReader.readLine();
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }
}

