/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard;

import freenetmessageboard.core.ChessLounge;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FMBSettings;
import freenetmessageboard.core.ForwardDemon;
import freenetmessageboard.core.MessageArchiveReceiver;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.NewsgroupDataModel;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.fcpinterface.FCPConfig;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.gui.BetaGUI;
import freenetmessageboard.gui.ColorsAndIcons;
import freenetmessageboard.gui.DummieGUI;
import freenetmessageboard.gui.GUIInterface;
import java.io.IOException;

public class Main {
    private static GUIInterface gui;

    public static GUIInterface getGUI() {
        return gui;
    }

    public static void shutDown() {
        System.err.println("closing fmb...");
        try {
            MessagePool.instance().saveToDisk();
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println("failed to close down properly...");
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        CoreLogger.logLevel = 1;
        FCPLogger.setLoggingLevel(FCPLogger.INTERFACE_WARNING);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("--autoListen")) {
                    bl = true;
                } else if (stringArray[n].equals("--forward")) {
                    bl4 = true;
                } else if (stringArray[n].equals("--verbose")) {
                    CoreLogger.logLevel = 2;
                } else if (stringArray[n].equals("--fcpPort")) {
                    FCPConfig.setPort(Integer.parseInt(stringArray[++n]));
                    System.err.println("fcp port set to " + FCPConfig.getPort());
                } else if (stringArray[n].equals("--fcpHost")) {
                    FCPConfig.setHostname(stringArray[++n]);
                    System.err.println("fcp host set to " + FCPConfig.getHostname());
                } else if (stringArray[n].equals("--help")) {
                    throw new Exception();
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            System.err.println("syntax: java -jar fmb.jar [--fcpPort portNr] [--fcpHost ip.adress] [--verbose] [--autoListen]");
            System.exit(-1);
        }
        if (bl4) {
            gui = DummieGUI.instance();
            PersonalInfo.setDemonMode("[forwarder]");
            MessagePool.instance().processNewMessages();
            ForwardDemon forwardDemon = new ForwardDemon();
            MessagePool.instance().start();
            forwardDemon.start();
            return;
        }
        gui = BetaGUI.instance();
        BetaGUI.instance().activateGUI();
        ColorsAndIcons.instance();
        FMBSettings.instance().setAutoListen(bl);
        PersonalInfo.instance();
        if (PersonalInfo.instance().isDefault()) {
            CoreLogger.log("show personal information dialog...", 2);
            gui.showPersonalInformationDialog(PersonalInfo.instance());
            try {
                PersonalInfo.instance().saveToDisk();
            }
            catch (IOException iOException) {
                CoreLogger.log("failed to save updated personal info to disk", 0);
            }
        }
        MessagePool.instance();
        ContactList.instance();
        ChessLounge.instance();
        MessageArchiveReceiver.instance();
        NewsgroupDataModel.instance();
        NewsgroupDataModel.instance().setMarkNewMessagesAsUnread(false);
        MessagePool.instance().processNewMessages();
        NewsgroupDataModel.instance().setMarkNewMessagesAsUnread(true);
        FMBSettings.instance().setAutoReply(bl2);
        FMBSettings.instance().setAutoForward(bl3);
        MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
        MessageArchiveReceiver.instance().start();
        MessagePool.instance().start();
    }
}

