package fiw.gui.awt;

import java.awt.*;

/** A WizardPanel is one of the components you can see on the right
 * side of the FIW window. This class provides an abstract superclass
 * for them and contains factory methods for getting all available
 * WizardPanels. */

public abstract class WizardPanel extends Panel {

    protected Wizard parent;
    
    public WizardPanel(Wizard parent) {
	super(new GridBagLayout());
	this.parent=parent;
    }
    static GridBagConstraints gbcLeft=new GridBagConstraints();
    static GridBagConstraints gbcRight=new GridBagConstraints();
    static GridBagConstraints gbcBottom=new GridBagConstraints();
    static {
	gbcLeft.anchor=GridBagConstraints.EAST;
	gbcRight.fill=GridBagConstraints.HORIZONTAL;
	gbcRight.gridwidth=GridBagConstraints.REMAINDER;
	gbcRight.weightx=1.0;
	gbcBottom.weighty=1.0;
	gbcBottom.gridwidth=GridBagConstraints.REMAINDER;
	gbcBottom.fill=GridBagConstraints.BOTH;
	gbcBottom.insets=new Insets(4,4,4,4);
    }

    public abstract int getNext();
    public abstract int getPrev();
    public abstract void refresh();

    public static int getCount() {
	return 11;
    }
    
    public static WizardPanel getPanel(int no, Wizard w) {
	switch(no) {
	case 0: return new ServerPortWP(w);
	case 1: return new TuningWP(w);
	case 2: return new SelectWP(w); //old style
	case 3: return new MainSettingsWP(w);
	case 4: return new DBRSettingsWP(w);
	case 5: return new ParserSettingsWP(w);
	case 6: return new DescriptionWP(w);
	case 7: return new DeleteProjectWP(w); //old style
	case 8: return new InsertWP(w);
	case 9: return new NimInsertWP(w); //old style
	case 10: return new CheckNimWP(w);
	default: return null;
	}
    }
}
