package fiw.gui.awt;
import fiw.core.*;
import fiw.gui.*;
import fiw.*;

import java.awt.*;
import java.awt.event.*;

/** This class creates the main window and loads WizardPanels into it
 * - and also manages the descriptive text on the left and the buttons
 * on the bottom */

public class Wizard extends Frame implements ActionListener,
					     ProjectKnower {
    Panel steps;
    CardLayout stepsLayout;
    TextArea desc;
    int current=0;
    WizardPanel[] stepPanel;

    /**
     * FIW's main icon, used at multiple positions.
     */
    public static final java.awt.Image fiwIcon=
    java.awt.Toolkit.getDefaultToolkit()
	.createImage(Main.class.getResource("/res/icon.gif"));

    
    /** the number of the project inserted at the moment */
    int projectnum=-1;

    private boolean advancedOpen = false;
    
    public Wizard() {
	super (I18n.format("WindowCaption", Main.VERSION));
	Panel p,p2;
	Button b;
	setBackground(Color.lightGray);
	setIconImage(fiwIcon);	
	add("Center",p=new Panel(new GridLayout(1,2)));
	p.add(p2=new Panel(new BorderLayout()));
	
	p2.add("Center",desc=new TextArea("",25,40,
			TextArea.SCROLLBARS_VERTICAL_ONLY));
	desc.setEditable(false);
	p2.add("East", new Panel() {
		public Dimension getPreferredSize() {
		    return new Dimension (12,12);
		}

		public void paint (Graphics g) {
		    int w=getWidth(), h=getHeight();
		    g.fillRect(w/2-1,0,2,h);
		}
	    });
	p.add(steps=new Panel(stepsLayout=new CardLayout()));
	add("South",p=new Panel(new GridLayout(1,3)));
	p.add(b=new Button(I18n.get("WizardBack")));
	b.setActionCommand("Back");
	b.addActionListener(this);
	p.add(b=new Button(I18n.get("WizardNext")));
	b.setActionCommand("Next");
	b.addActionListener(this);
	p.add(b=new Button(I18n.get("WizardQuit")));
	b.setActionCommand("Quit");
	b.addActionListener(this);
	stepPanel=new WizardPanel[WizardPanel.getCount()]; 
	for (int i=0; i<stepPanel.length; i++) {
	    steps.add(""+i,stepPanel[i]=WizardPanel.getPanel(i, this));
	}
	stepsLayout.show(steps,""+current);
	showText(current);
	stepPanel[current].refresh();
	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    quit();
		}
	    });
	pack();
	show();
    }
    public void actionPerformed(ActionEvent evt) {
	String cmd=evt.getActionCommand();
	if (cmd.equals("Quit")) {
	    quit();
	} else if(cmd.equals("Next")) {
	    current=stepPanel[current].getNext();
	    if (current==-1) {
		dispose();
	    } else {
		stepsLayout.show(steps,""+current);
		stepPanel[current].refresh();
		showText(current);
	    }
	} else if(cmd.equals("Back")) {
	    current=stepPanel[current].getPrev();
	    if (current==-1) {
		dispose();
		new NoWizard();
	    } else {
		stepsLayout.show(steps,""+current);
		showText(current);
	    }
	} else {
	    System.out.println(cmd);
	}
    }

    void quit() {
	System.exit(0);
    }

    void showText(int no) {
	desc.setText(FileUtil.getWizardDesc(no));
    }

    public int getProjectNumber() {
	return projectnum;
    }

    public void setProjectNumber(int newNumber) {
	projectnum=newNumber;
    }

    public void setAdvancedOpen(boolean advOpen) {
	advancedOpen = advOpen;
    }

    public boolean isAdvancedOpen() {
	return advancedOpen;
    }
}
