package fiw.gui.awt;

import fiw.core.GUIHelper;

import java.awt.*;
import java.awt.event.*;

/**
 * A panel to visualize the {@link fiw.core.option.TimestampOptionType}.
 */
public class TimestampPanel extends Panel implements ItemListener {

    private Checkbox ch;
    private TextField tf;
    private String state;

    public TimestampPanel(Container parent, String caption) {
	parent.add(ch = new Checkbox(caption), WizardPanel.gbcLeft);
	ch.addItemListener(this);
	parent.add(tf = new TextField(""), WizardPanel.gbcRight);
	tf.setEditable(false);
    }

    public void setValue(String state) {
	this.state=state;
	if (state.length() == 0) {
	    ch.setState(false);
	    tf.setText("");
	} else {
	    ch.setState(true);
	    tf.setText(GUIHelper.getInstance().getDateString
		       (Long.parseLong(state)));
	}
    }

    public String getValue() {
	return state;
    }

    public void itemStateChanged(ItemEvent evt) {
	if (ch.getState()) {
	    setValue(""+System.currentTimeMillis());
	} else {
	    setValue("");
	}
    }
}
