package fiw.gui.awt;
import fiw.core.*;
import fiw.core.option.*;

import java.awt.*;
import java.awt.event.*;


/**
 * The first WizardPanel where you have to select your FCP host and
 * port. There also appears a notice on this panel if you do not have
 * the latest Freenet build.
 */

public class ServerPortWP extends GlobalOptionWizardPanel
    implements ActionListener {
    boolean okay=false;
    Checkbox advanced;
    
    public ServerPortWP(Wizard w) {
	super(0, w);
	Button b;
	add(b=new Button(I18n.get("CheckServer")),gbcRight);
	b.addActionListener(this);
	add(advanced=new Checkbox(I18n.get("ShowAdvanced")),
	    gbcRight);
	add(errors=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
	errors.setEditable(false);
    }
    
    public int getNext() {
	if (!okay) doCheck();
	if (!okay) return 0;
	parent.setAdvancedOpen(advanced.getState());
	if (advanced.getState()) return 1;
	return 2;
    }

    public int getPrev() {
	return -1;
    }

    public void refresh() {
	super.refresh();
	doCheck();
    }

    public void actionPerformed(ActionEvent evt) {
	doCheck();
    }

    void doCheck() {
	AbstractOptions opts = getOptionsList();
	okay=false;
	for (int i=0;i<opts.getSettings().length;i++) {
	    if (!flushOption(i,opts.getSettings())) return;
	}
	int p;
	try {
	    p=Integer.parseInt(opts.getOption("fcp.port").getValue());
	} catch (NumberFormatException e) {
	    errors.setText(I18n.format("ErrInvalidPort", e.getMessage()));
	    return;
	}
	String h=opts.getOption("fcp.host").getValue();
	String s = GUIHelper.getInstance().handshake(h,p);
	if (s==null) {
	    errors.setText(I18n.get("ErrNoConn"));
	} else {
	    errors.setText(s);
	    okay=true;
	}
    }
}
