package fiw.gui.awt;

import fiw.core.*;

import java.awt.*;
import java.awt.event.*;

/**
 * This is the main "select action" WizardPanel. Responsible for moving
 * projects up and down and for cloning them.
 */
public class SelectWP extends WizardPanel implements ActionListener {
    Checkbox newProject, editProject, uploadProject,
	deleteProject, uploadFile, checkNIMs;
    List projects;
    
    public SelectWP(Wizard w) {
	super(w);
	Button b;
	Panel p;
	CheckboxGroup cg=new CheckboxGroup();
	add(newProject=new Checkbox (I18n.get("SelectNew"),cg,false),
	    gbcRight);
	add(editProject=new Checkbox(I18n.get("SelectEdit"), cg, false),
	    gbcRight);
	add(deleteProject=new Checkbox(I18n.get("SelectDelete"), cg,
				       false), gbcRight);
	add(uploadProject=new Checkbox(I18n.get("SelectUpload"), cg,
				       true),gbcRight);
	add(new Panel(),gbcRight);
	add(uploadFile=new Checkbox(I18n.get("SelectUploadNIM"), cg,
				       false),gbcRight);
	add(checkNIMs=new Checkbox(I18n.get("SelectCheckNIM"), cg,
				       false),gbcRight);
	add(new Panel(),gbcRight);
	add(p=new Panel(new GridLayout(2,1)),gbcRight);
	p.add(b=new Button(I18n.get("Open_LoadStatus")));
	b.setActionCommand("LoadStatus");
	b.addActionListener(this);
	p.add(b=new Button(I18n.get("Open_MetaDataBrowser")));
	b.setActionCommand("MetaDataBrowser");
	b.addActionListener(this);
	add(new Panel(),gbcRight);
	add(p=new Panel(new GridLayout(1,3)),gbcRight);
	p.add(b=new Button(I18n.get("ProjectMoveUp")));
	b.setActionCommand("Up");
	b.addActionListener(this);
	p.add(b=new Button(I18n.get("ProjectClone")));
	b.setActionCommand("Clone");
	b.addActionListener(this);
	p.add(b=new Button(I18n.get("ProjectMoveDown")));
	b.setActionCommand("Down");
	b.addActionListener(this);
	add(projects=new List(), gbcBottom);
    }

    public void refresh() {
	int selected = projects.getSelectedIndex();
	projects.removeAll();
	String[] pr=FIWSystem.setts().getProjectNames();
	for(int i=0;i<pr.length;i++) {
	    projects.add("["+(i+1)+"] "+pr[i]);
	}
	if (selected>=0 && selected < pr.length) {
	    projects.select(selected);
	}
    }

    public void actionPerformed(ActionEvent evt) {
	int projectnum=projects.getSelectedIndex();
	String cmd=evt.getActionCommand();
	GUIHelper gh = GUIHelper.getInstance();
	if ("LoadStatus".equals(cmd)) {
	    gh.openLoadStatus();
	} else if ("MetaDataBrowser".equals(cmd)) {
	    gh.openMetadataBrowser();
	} else if (projectnum!=-1) {
	    if ("Up".equals(cmd)) {
		if(gh.moveProjectUp(projectnum)) {
		    refresh();
		    projects.select(projectnum-1);
		}
	    } else if ("Down".equals(cmd)) {
		if (gh.moveProjectDown(projectnum)) {
		    refresh();
		    projects.select(projectnum+1);
		}
	    } else if ("Clone".equals(cmd)) {
		int newnum = gh.cloneProject(projectnum);
		refresh();
		projects.select(newnum);
	    }
	}
    }

    public int getNext() {
	if (newProject.getState()) {
	    parent.setProjectNumber(FIWSystem.setts().getProjCount());
	    return 3;
	}
	if (checkNIMs.getState()) {
	    return 10;
	}
	if (projects.getSelectedIndex()==-1) {
	    return 2;
	}
	parent.setProjectNumber(projects.getSelectedIndex());
	if (uploadFile.getState()) {
	    return 9;
	}
	if (editProject.getState()) {
	    return 3;
	}
	if (uploadProject.getState()) {
	    return 8;
	}
	if (deleteProject.getState()) {
	    return 7;
	}
	return 1;
    }

    public int getPrev() {
	if (parent.isAdvancedOpen()) return 1;
	return 0;
    }
}
