package fiw.gui.awt;
import fiw.core.option.*;
import fiw.core.*;

import java.awt.*;

/** A WizardPanel that shows options from the
 * {@link fiw.core.option.Options} class for one project.
 */

public abstract class ProjectOptionWizardPanel
    extends OptionBasedWizardPanel {
    
    public ProjectOptionWizardPanel(int panelNumber, Wizard w) {
	super(panelNumber, new Options(w), w);
	layoutOptions();
    }

    protected boolean isDBR() {
	return getOptionsList().getOption("dbr").getValue().equals("true");
    }

    protected Component layoutSpecials(Option o) {
	switch (o.getSpecialNumber())  {
	case 6: // DBR panel header/skipper
	    add(new Panel(),gbcLeft); 
	    add(new Label(I18n.get("Days")),gbcLeft);
	    add(new Label(I18n.get("Time")),gbcRight);
	    return null;
	default:
	    add(new Label("[ERROR] could not handle special "+
			  "option! This is a bug."), gbcRight);
	    return null;
	}	
    }
}
