package fiw.gui.awt;
import fiw.core.*;

import java.awt.*;
import java.io.File;

/**
 * WizardPanel managing the "parser settings" of a project
 */
public class ParserSettingsWP extends ProjectOptionWizardPanel {
    Checkbox parse;
    TextArea files;
    
    public ParserSettingsWP(Wizard w) {
	super(5,w);
	add(parse=new Checkbox (I18n.get("ParseIndex"), false), gbcRight);
	add(new Label(I18n.get("ParseAdditional")), gbcRight);
	add(files=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
    }
    public void refresh() {
	if (norefresh) {
	    norefresh=false;
	    return;
	}
	super.refresh();
	String toparse= FileUtil.loadFile (parseFile());
	if (toparse.startsWith("index.html\n")) {
	    parse.setState(true);
	    toparse=toparse.substring(11);
	} else {
	    parse.setState(false);
	}
	files.setText(toparse);
	files.setEditable(parseDir().isDirectory());
	parse.setEnabled(parseDir().isDirectory());
    }
    
    private void saveSettings() {
	if (!save()) throw new RuntimeException("Cannot be!");
	String toparse = (parse.getState()?"index.html\n":"")+files.getText();
	if (toparse.length() != 0 && !toparse.equals("\n")) {
	    FileUtil.saveFile(parseFile(), toparse);
	} else {
	    parseFile().delete();
	}
    }
    
    public int getNext() {
	saveSettings();
	return 6;
    }

    public int getPrev() {
	if (isDBR()) return 4;
	return 3;
    }

    public File parseDir() {
	return FileUtil.fiwDir(FIWSystem.setts().getProjectFile
				(parent.getProjectNumber()));
    }
    public File parseFile() {
	return new File(parseDir(), "parse.ini");
    }    
}
