package fiw.gui.awt;
import fiw.core.option.*;

import java.awt.*;

/** A WizardPanel that shows options an Option[].
 * These options are translated
 * to text boxes etc. according to their OptionType */

public abstract class OptionBasedWizardPanel extends WizardPanel {

    private int panelNumber;
    protected boolean norefresh;
    protected Component[] settings;
    protected TextArea errors = null;
    private AbstractOptions opts;

    protected AbstractOptions getOptionsList() {return opts;}

    
    public OptionBasedWizardPanel(int panelNumber, AbstractOptions opts,
				  Wizard w) {
	super(w);
	this.panelNumber=panelNumber;
	this.opts=opts;
    }

    protected void layoutOptions() {
	DBRSlotPanel lastDBR = null;
	Option[] sets = opts.getSettings();
	settings=new Component[sets.length];
	for (int i=0;i<sets.length;i++) {
	    Option o = sets[i];
	    if (o.getPanelNumber() != panelNumber ) continue;
	    if (o.isSpecial()) {
		if (o instanceof ButtonOption) {
		    Button b;
		    add(b = new Button(o.getName()), gbcRight);
		    b.addActionListener(new ButtonOptionActionListener
					((ButtonOption) o, this));
		    settings[i] = b;
		} else {
		    settings[i]= layoutSpecials(o);
		}
	    } else {
		OptionType t = o.getType();
		if (t instanceof BooleanOptionType) {
		    add(settings[i]=new Checkbox(o.getName(),
						 false),
			gbcRight);
		} else if (t instanceof ChoiceOptionType) {
		    add(settings[i] = new ChoicePanel((ChoiceOptionType)t),
			gbcRight);
		} else if (t instanceof DBRSlotOptionType) {
		    add(new Label(o.getName()+":"),gbcLeft);		    
		    add(settings[i] = new DBRSlotPanel((DBRSlotOptionType)t,
						       lastDBR),
			gbcRight);
		    if (lastDBR != null) {
			lastDBR.setFollowing((DBRSlotPanel)settings[i]);
		    }
		    lastDBR = (DBRSlotPanel)settings[i];
		} else if (t instanceof DayTimeOptionType) {
		    settings[i] = new DayTimePanel(this, o.getName()+":");
 		} else if (t instanceof TimestampOptionType) {
		    settings[i] = new TimestampPanel(this, o.getName()+":");
		} else {
		    add(new Label(o.getName()+":"),gbcLeft);
		    if (sets.length > i+1 && // 2 options in one row
			sets[i+1].getPanelNumber() == panelNumber &&
			sets[i+1] instanceof ButtonOption &&
			((ButtonOption)sets[i+1]).isGroupedWithPrevious()) {
			Panel p;
			Button b;
			add(p= new Panel(new BorderLayout()), gbcRight);
			p.add("Center", settings[i]=new TextField(""));
			i++;
			o = sets[i];
			p.add("East", b = new Button(o.getName()));
			b.addActionListener(new ButtonOptionActionListener
					    ((ButtonOption) o, this));
			settings[i] = b;
		    } else {
			add(settings[i]=new TextField(""),gbcRight);
		    }
		}
	    }
	}
    }

    public void refresh() {
	if (norefresh) {
	    norefresh=false;
	    return;
	}
	Option[] sets = loadOptions();
	for (int i=0;i<sets.length;i++) {
	    refreshOption(i, sets);
	}
	if (errors != null) errors.setText("");
    }

    public void refreshOption(int no, Option[] sets) {
	Option o = sets[no];
	if (o.getPanelNumber() == panelNumber && o instanceof ButtonOption) {
	    ((Button)settings[no]).setEnabled(o.isEnabled());
	}
	if (o.getPanelNumber() == panelNumber && !o.isSpecial()) {
	    OptionType t = o.getType();
	    if (t instanceof BooleanOptionType) {
		((Checkbox)settings[no]).setState
		    ("true".equals(o.getValue()));
		((Checkbox)settings[no]).setEnabled(o.isEnabled());
	    } else if (t instanceof ChoiceOptionType) {
		((ChoicePanel)settings[no]).setState(o.getValue());
		((ChoicePanel)settings[no]).setEditable(o.isEnabled());
	    } else if (t instanceof DBRSlotOptionType) {
		((DBRSlotPanel) settings[no]).setValue("");
		((DBRSlotPanel)	settings[no]).setEditable(o.isEnabled());
	    } else if (t instanceof DayTimeOptionType) {
		((DayTimePanel)settings[no]).setValue(o.getValue());
 	    } else if (t instanceof TimestampOptionType) {		    
 		((TimestampPanel)settings[no]).setValue(o.getValue());
	    } else {
		((TextField)settings[no]).setText(o.getValue());
		((TextField)settings[no]).setEditable(o.isEnabled());
	    }
	}
    }

    protected boolean save() {
	Option[] sets = opts.getSettings();
	for(int i=0;i<sets.length;i++) {
	    if (!flushOption(i, sets)) {
		norefresh=true;
		return false;
	    }
	}
	opts.save();
	return true;
    }


    protected boolean flushOption(int no, Option[] sets) {
	Option o = sets[no];
	if (o.getPanelNumber() == panelNumber && !o.isSpecial()) {
	    OptionType t = o.getType();
	    String value;
	    if (t instanceof BooleanOptionType) {
		value = ((Checkbox)settings[no]).getState()?"true":"false";
	    } else if (t instanceof ChoiceOptionType) {
		value = ((ChoicePanel)settings[no]).getState();
	    } else if (t instanceof DBRSlotOptionType) {
		value = ((DBRSlotPanel)settings[no]).getValue();
	    } else if (t instanceof DayTimeOptionType) {
		value = ((DayTimePanel)settings[no]).getValue();
 	    } else if (t instanceof TimestampOptionType) {
 		value = ((TimestampPanel)settings[no]).getValue();
	    } else {
		value = ((TextField)settings[no]).getText();
	    }
	    if (o.isEnabled() && !o.setValue(value)) {
		if (errors != null) {
		    errors.setText(o.getName()+": "+
				   o.getInvalidReason(value));
		} else {
		    System.err.println(o.getName()+": "+
				       o.getInvalidReason(value));
		}
		return false;
	    }
	}
	return true;
    }
    protected abstract Component layoutSpecials(Option o);
    
    protected final Option[] loadOptions() {
	opts.load();
	return opts.getSettings();
    }

    protected final void saveOptions() {
	opts.save();
    }
}
