package fiw.gui.awt;
import fiw.core.*;
import fiw.core.insert.event.*;

import java.awt.*;

/** WizardPanel for inserting NIMs and files */

public class NimInsertWP extends WizardPanel {
    private Checkbox name,contents,redirect,rawmetadata, advance;
    private TextArea desc;
    private TextField key, htl,ctype;
    private boolean norefresh=false;
    
    public NimInsertWP(Wizard w) {
	super(w);
	add(new Label(I18n.get("NIM_Key")),gbcLeft);
	add(key=new TextField(),gbcRight);
	add(advance=new Checkbox(I18n.get("AutoAdvance")), gbcRight);
	add(new Label(I18n.get("NIM_HTL")),gbcLeft);
	add(htl=new TextField("15"),gbcRight);
	add(new Label(I18n.get("NIM_CType")),gbcLeft);
	add(ctype=new TextField("text/plain"),gbcRight);
	CheckboxGroup cg=new CheckboxGroup();
	add(name=new Checkbox (I18n.get("NIM_Filename"),cg,false),
	    gbcRight);
	add(contents=new Checkbox(I18n.get("NIM_Contents"), cg, true),
	    gbcRight);
	add(redirect=new Checkbox(I18n.get("NIM_Redirect"), cg,
				  false), gbcRight);
	add(rawmetadata=new Checkbox(I18n.get("NIM_Raw"), cg,
				     false),gbcRight);
	add(desc=new TextArea("",10,10,
			      TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
    }
    
    public int getNext() {
	if (send()) return 2;
	norefresh=true;
	return 9;
    }

    public int getPrev() {
	return 2;
    }

    public void refresh() {
	if (norefresh) {
	    norefresh=false;
	    return;
	}
	int projectnum= parent.getProjectNumber();
	key.setText(GUIHelper.getInstance().getDefaultNIM(projectnum));
    }

    private boolean send() {
	int htlvalue;
	try {
	    htlvalue=Integer.parseInt(htl.getText());
	} catch (NumberFormatException e) {
	    return false;
	}
	boolean adv = advance.getState();
	InsertDialog dialog = new InsertDialog(false);
	boolean res =  GUIHelper.getInstance().handleNIMInsert
	    (desc.getText(), htlvalue, adv, key.getText(),
	     contents.getState(), name.getState(), redirect.getState(),
	     rawmetadata.getState(), ctype.getText(),
	     new InsertLoggerListener(dialog));
	if (!res) dialog.dispose();
	return res;
    }
}
