package fiw.gui.awt;
import fiw.core.*;

import java.awt.*;
import java.awt.event.*;

/**
 * WizardPanel managing the "main settings" of a project 
 */
public class MainSettingsWP extends ProjectOptionWizardPanel
    implements ActionListener, MyLogger {
    
    public MainSettingsWP(Wizard w) {
	super(3, w);
 	Button b;
	add(b=new Button(I18n.get("Check_Settings")),gbcRight);
	b.addActionListener(this);
	add(errors=new TextArea(
		"", 10, 10, TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
	errors.setEditable(false);
    }
    
    public void refresh() {
	if (GUIHelper.getInstance().isTestRunning()) return;
	super.refresh();
	errors.setText(I18n.get("NotCheckedYet"));
    }
        
    public void actionPerformed(ActionEvent evt) {
	if (GUIHelper.getInstance().isTestRunning()) return;
	if (save()) {
	    errors.setText("");
	    testSettings();
	} else {
	    refresh();
	}
    }

    public int getNext() {
	if (GUIHelper.getInstance().isTestRunning() || !save()) return 3;
	if (isDBR())  return 4;
	return 5;
    }

    public int getPrev() {
	if (GUIHelper.getInstance().isTestRunning()) return 3;
	return 2;
    }

    public void testSettings() {
	GUIHelper.getInstance().testSettings(parent.getProjectNumber(), this);
    }

    public void addlog(String s) {
	errors.append(s+"\n");
    }
    
    public void addlogNoNewline(String s) {
	errors.append(s);
    }

    public void done() {}
    
}
