package fiw.gui.awt;
import fiw.core.*;
import fiw.core.insert.*;
import fiw.core.insert.event.*;

import java.awt.*;

/** the wizard panel where you setup the last settings for an
 * upload */

public class InsertWP extends ProjectOptionWizardPanel {
    Checkbox testinsert, onlyfec, clearprogress, useParser;
    
    public InsertWP(Wizard w) {
	super(8, w);
	add(testinsert=new Checkbox(I18n.get("TestInsert")),gbcRight);
	add(onlyfec=new Checkbox(I18n.get("NoRealInsert")),
	    gbcRight);
	add(clearprogress=new Checkbox(I18n.get("ClearProgress")),
	    gbcRight);
	add(useParser=new Checkbox(I18n.get("UseParser")),
	    gbcRight);
	add(errors=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
	errors.setEditable(false);
    }
    
    public void refresh() {
	if (norefresh) {
	    norefresh=false;
	    return;
	}
	super.refresh();
	errors.setText("");
	testinsert.setState(false);
	onlyfec.setState(false);
	clearprogress.setState(false);
	useParser.setState(true);
    }
    
    boolean start() {
	if (!save()) return false;
	int htlvalue=0;
	if (onlyfec.getState()) {
	    htlvalue=-2;
	} else if (testinsert.getState()) {
	    htlvalue=-1;
	} else {
	    htlvalue=Integer.parseInt(getOptionsList().
				      getOption("htl").getValue());
	}
	errors.setText(I18n.get("Starting_Insert"));
	new InsertEngine(FIWSystem.getInstance().getFCPConnection(),
			 parent.getProjectNumber(), htlvalue,
			 clearprogress.getState(),
			 useParser.getState(),
			 new InsertLoggerListener(new InsertDialog(true)));
	return true;
    }

    
    public int getNext() {
	if (start())
	    return 2;
	else {
	    norefresh=true;
	    return 8;
	}
    }

    public int getPrev() {
	return 2;
    }
}
