package fiw.gui.awt;
import fiw.core.*;
import fiw.core.insert.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;

/** this class contains the Dialog shown while the insertion process
 * is running. */
    
public class InsertDialog extends Frame implements InsertLogger {

    Stoppable myEngine;
    TextArea result, status, status2;

    String[] threadstat;
    int[] threadnum, globalnumber;
    List actions = new Vector(), actnumbers = new Vector();
    int maxnum=0;
    boolean autoclose=false;
    boolean isstopping=false;
    
    public InsertDialog(boolean twopart) {
	this(twopart,false);
    }

    public InsertDialog(boolean twopart, boolean autoclose) {
        super (I18n.get("Insertion_in_progress"));
	this.autoclose=autoclose;
	Font font = new Font("Monospaced",Font.PLAIN,12);
        add("Center",result=new TextArea("",
					 twopart?15:30, 80,
                                         TextArea.SCROLLBARS_VERTICAL_ONLY));
        result.setEditable(false);
	result.setFont(font);
	setIconImage(Wizard.fiwIcon);
	Panel p;
	if (twopart) {
	    int threads = Integer.parseInt
		(FIWSystem.setts().getProperty("tuning.threadcount"));
	    threadnum = new int[threads];
	    globalnumber = new int[threads];
	    threadstat = new String[threads];
	    add("South",p=new Panel(new GridLayout(1,2)));
	    p.add(status = new TextArea("",15,40));
	    status.setEditable(false);
	    status.setFont(font);
	    p.add(status2 = new TextArea("",15,40));
	    status2.setEditable(false);
	    status2.setFont(font);
	} else {
	    threadstat = new String[0];
	}
        addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
		    if (myEngine != null) {
			myEngine.stopRunning();
			myEngine=null;
			isstopping=true;
		    } else {
			isstopping=false;
			dispose();
		    }
                }
            });
	Point pt=getLocation();
	setLocation(pt.x+50,pt.y+50);
        pack();
        show();
    }

    public synchronized void addlog(String s) {
	addlogNoNewline(s+"\n");
    }
    
    public synchronized void addlogNoNewline (String s) {
	try {
	    result.append(s);
	} catch (StringIndexOutOfBoundsException e) {
	    result.setText(I18n.get("LogTruncated")+"\n"+s);
	}
    }

    public synchronized void setStatus(String s) {
	this.setTitle(s);
    }

    public synchronized int addThread(int globalno) {
	if (threadstat.length==0) return -1;
	for (int i=0;i<threadstat.length;i++) {
	    if (threadstat[i]==null) {
		threadstat[i]=I18n.get("ThreadStarting");
		threadnum[i]=++maxnum;
		globalnumber[i] = globalno;
		actions.add(I18n.get("ActionStarting"));
		actnumbers.add(new Integer(globalno));
		refreshview();
		return i+1;
	    }
	}
	addlog("** Thread timing error! **");
	return -1;
    }

    private void refreshview() {
	StringBuffer sb= new StringBuffer(I18n.get("CurrActHeader"));
	for (int i=0;i<threadstat.length;i++) {
	    if (threadstat[i]==null) 
		sb.append('\n');
	    else {
		int j=globalnumber[i];
		sb.append(j<10?"#0":"#").append(j).append(": ")
		    .append(threadstat[i]).append('\n');
	    }
	}
	status.setText(sb.toString());
	sb.setLength(0);
	sb.append(I18n.get("AllActHeader"));
	for (int i=0;i<actions.size();i++) {
	    int j=((Integer)actnumbers.get(i)).intValue();
	    sb.append((j<10?"#0":"#")).append(j).append(": ")
		.append((String)actions.get(i)).append('\n');
	}
	status2.setText(sb.toString());
	status2.append("");
    }


    public synchronized void setThread(int no, String s) {
	if (no==-1) return;
	threadstat[no-1]=s;
	actions.set(threadnum[no-1]-1,s);
	refreshview();
    }

    public synchronized void setThread(int no, int retry, int actionIndex,
				       String desc) {
	setThread(no,(retry==-2||retry==-3?"":(retry==-1?"-- ":
				    InsertContext.num(retry+1)+" "))+
		  InsertContext.ACTIONS[actionIndex]+
		  (retry==-3?"   ":"")+
		  desc);
    }

    public synchronized void removeThread(int no) {
	if (no==-1) return;
	threadstat[no-1]=null;
	refreshview();
    }

    public synchronized void restart() {
	actions.clear();
	maxnum=0;
    }

    public void done() {
	if (autoclose) {
	    System.exit(0);
	}
	if (isstopping) {
	    dispose();
	}
	myEngine=null;
    }

    public void iamhere (Stoppable ie) {
	myEngine=ie;
    }
}
