package fiw.gui.awt;
import fiw.core.option.*;
import fiw.core.*;

import java.awt.*;

/** A WizardPanel that shows options from the
 * {@link fiw.core.option.GlobalOptions} class.
 */

public abstract class GlobalOptionWizardPanel
    extends OptionBasedWizardPanel {

    public GlobalOptionWizardPanel(int panelNumber, Wizard w) {
	super(panelNumber, new GlobalOptions(false), w);
	layoutOptions();
    }
	
    protected Component layoutSpecials(Option o) {
	switch (o.getSpecialNumber())  {
	case 1:
	    add(new Label(I18n.get("Geeky_settings")+" ---------- "),gbcRight);
	    return null;
	default:
	    add(new Label("[ERROR] could not handle special "+
			  "option! This is a bug."), gbcRight);
	    return null;
	}	
    }
}
