package fiw.gui.awt;
import fiw.core.*;

import java.awt.*;
import java.io.*;

/** WizardPanel where you can enter the descripion for a freesite */

public class DescriptionWP extends ProjectOptionWizardPanel {
    TextArea desc;
    TextField title,category,author;

    public DescriptionWP(Wizard w) {
	super(6,w);
	add(desc=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
    }
    
    public int getNext() {
	if (save())
	    return 2;
	return 6;
    }

    public int getPrev() {
	return 5;
    }

    public void refresh() {
	super.refresh();
	desc.setText(FileUtil.loadFile
		     (new File(descDir(), "description.txt")));
	desc.setEditable(descDir().isDirectory());
    }

    public boolean save() {
	String s=desc.getText();
	if (!s.equals("") &&  !s.startsWith(")")) 
	    FileUtil.saveFile(new File(descDir(), "description.txt"), s);
	return super.save();
    }

    public File descDir() {
	return FIWSystem.getInstance().getSettings()
	    .getProjectFile(parent.getProjectNumber());
    }
}
