package fiw.gui.awt;

import fiw.core.*;
import java.awt.*;

/**
 * WizardPanel to confirm a project delete; also code to delete a
 * project
 */

public class DeleteProjectWP extends WizardPanel {
    
    Checkbox yes;
    TextArea desc;
    
    public DeleteProjectWP(Wizard w) {
	super(w);
	add(new Label(I18n.get("DeleteWarning")),gbcRight);
	add(new Label(I18n.get("DeleteQuestion")),gbcRight);
	add(yes=new Checkbox(I18n.get("DeleteYes")),gbcRight);
	add(desc=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
	desc.setEditable(false);
    }
    
    public int getNext() {
	if (!yes.getState()) {
	    return 7;
	}
	int projectnum = parent.getProjectNumber();
	GUIHelper.getInstance().deleteProject(projectnum);
	return 2;
    }

    public int getPrev() {
	return 2;
    }

    public void refresh() {
	int projectnum = parent.getProjectNumber();
	yes.setState(false);
	desc.setText(GUIHelper.getInstance().getBriefProjectInfo(projectnum));
    }
}
