package fiw.gui.awt;
import fiw.core.*;

import java.awt.*;



/**
 * A "Panel" for setting up intervals consisting of days and time.
 */
public class DayTimePanel extends Panel {

    private TextField day, time;
    
    public DayTimePanel(Container parent, String caption) {
	parent.add(new Label(caption),WizardPanel.gbcLeft);
	parent.add(day=new TextField(3),WizardPanel.gbcLeft);
	parent.add(time=new TextField(""),WizardPanel.gbcRight);
    }

    public void setValue(String state) {
	day.setText(""+(Integer.parseInt(state)/86400));
	time.setText(Settings.makeTime(Integer.parseInt(state)%86400));
    }

    public String getValue() {
	String value;
	String days = day.getText(),
	    tme = time.getText();
	int val1 = Settings.parseTime(tme);
	try {
	    int val = Integer.parseInt(days)
		* 86400 + val1;
	    value=""+val;
	} catch (NumberFormatException ex) {
	    value = days;
	}
	if (val1 == -1) value ="getSeconds('"+tme+"')";
	return value;
    }
}
