package fiw.gui.awt;
import fiw.core.option.*;
import fiw.core.*;

import java.awt.*;
import java.awt.event.*;


/**
 * A panel that shows a DBR slot. Controlled by
 * {@link fiw.core.option.DBRSlotOptionType}.
 * @author mihi
 */
public class DBRSlotPanel extends Panel implements ActionListener {

    private DBRSlotOptionType ot;
    private TextField value;
    private int increment, offset;
    private long numvalue;
    private DBRSlotPanel following = null, preceding;
    
    public DBRSlotPanel(DBRSlotOptionType ot, DBRSlotPanel preceding) {
	super(new BorderLayout());
	this.ot = ot;
	this.preceding = preceding;
	Button b;
	add("West",b=new Button("<"));
	b.addActionListener(this);
	add("Center",value=new TextField(""));
	value.setEditable(false);
	add("East",b=new Button(">"));
	b.addActionListener(this);
    }

    public void setFollowing(DBRSlotPanel following) {
	this.following=following;
    }
    
    public String getValue() {
	if (increment!=0)
	    return ""+numvalue;
	else
	    return "";
    }

    public void setValue(String v) {
	increment = Integer.parseInt(ot.getIncrement().getValue());
	offset = Integer.parseInt(ot.getOffset().getValue());
	long val;
	if (v.equals("")) {
	    val=GUIHelper.getInstance().getNextSlot(increment, offset);
	} else {
	    val = Long.parseLong(v);
	}
	updateValue(val);
    }
    

    public void setEditable(boolean editable) {
	if (!editable) {
	    increment = 0;
	    numvalue = 0;
	    value.setText(I18n.get("Slot_none"));
	}
    }
    protected void increaseValue(long v) {
	if (v > numvalue)
	    updateValue(v);
    }
    
    private void updateValue(long newval) {
	numvalue = newval;
	value.setText(GUIHelper.getInstance().getDateString(numvalue*1000));
	if (following != null && newval > following.numvalue)
	    following.updateValue(newval);
	if (preceding != null && preceding.numvalue > newval )
	    preceding.updateValue(newval);
    }

    public void actionPerformed(ActionEvent evt) {
	if (increment == 0) return;
	String cmd = evt.getActionCommand();
	if (">".equals(cmd)) {
	    updateValue(numvalue+increment);
	} else if ("<".equals(cmd)) {
	    updateValue(numvalue-increment);
	}
    }
}
