package fiw.gui.awt;
import fiw.core.*;

import java.awt.*;
import java.awt.event.*;

/**
 * WizardPanel managing the DBR of a project 
 */
public class DBRSettingsWP extends ProjectOptionWizardPanel
    implements ActionListener {
        
    public DBRSettingsWP(Wizard w) {
	super(4, w);
	Button b;
	add(b=new Button(I18n.get("DBR_Save_Calc")),gbcRight);
	b.addActionListener(this);
	add(errors=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
	errors.setEditable(false);
    }
    
    public void refresh() {
	if (norefresh) {
	    norefresh=false;
	    return;
	}
	super.refresh();
	long increment=Integer.parseInt(getOptionsList()
					.getOption("dbr.increment")
					.getValue());
	long offset=Integer.parseInt(getOptionsList()
				     .getOption("dbr.offset").getValue());
	errors.setText(GUIHelper.getInstance().getRollovers(increment,
							    offset));
    }
        
    public void actionPerformed(ActionEvent evt) {
	save();
	refresh();
    }

    public int getNext() {
	if (save())
	    return 5;
	return 4;
    }

    public int getPrev() {
	return 3;
    }
}
