package fiw.gui.awt;
import fiw.core.option.*;

import java.awt.*;


/**
 * A panel that shows radio buttons for a choice. Controlled by
 * {@link fiw.core.option.ChoiceOptionType}.
 * @author mihi
 */
public class ChoicePanel extends Panel {

    String[][] choices;
    CheckboxGroup cbg;
    Checkbox[] boxes;
    
    public ChoicePanel(ChoiceOptionType o) {
	super(new GridLayout(0,1));
	cbg=new CheckboxGroup();
	choices = o.getChoices();
	boxes = new Checkbox[choices[0].length];
	for(int i=0;i<boxes.length;i++) {
	    add(boxes[i]=new Checkbox (choices[0][i],cbg,false));
	}	
    }

    public String getState() {
	for (int i=0;i<boxes.length;i++) {
	    if (boxes[i].getState()) {
		return choices[1][i];
	    }
	}
	return "";
    }

    public void setState(String state) {
	for (int i=0;i<boxes.length;i++) {
	    if (choices[1][i].equals(state)) {
		boxes[i].setState(true);
	    }
	}
    }

    public void setEditable(boolean editable) {
	for (int i=0;i<boxes.length;i++) {
	    boxes[i].setEnabled(editable);
	}
    }
}
