package fiw.gui.awt;
import fiw.core.*;

import java.awt.*;

/**
 * The wizard panel that asks for settings for checking your NIMs.
 */

public class CheckNimWP extends GlobalOptionWizardPanel {
    
    public CheckNimWP(Wizard w) {
	super(10,w);
	add(errors=new TextArea("",10,10,
				TextArea.SCROLLBARS_VERTICAL_ONLY),
	    gbcBottom);
	errors.setEditable(false);
    }
    
    boolean start() {
	if (!save()) return false;
	int htlvalue=0, advvalue;
	htlvalue=Integer.parseInt(getOptionsList().
				  getOption("nimgethtl").getValue());
	advvalue=Integer.parseInt(getOptionsList().
				  getOption("nimgetadvance").getValue());
	errors.setText(I18n.get("Starting_NIM_Check"));
	GUIHelper.getInstance().startNimChecker(new InsertDialog(true),
						htlvalue, advvalue);
	return true;
    }
    
    public int getNext() {
	if (start())
	    return 2;
	else {
	    return 10;
	}
    }

    public int getPrev() {
	return 2;
    }
}
