package fiw.gui.awt;

import fiw.core.option.*;

import java.awt.event.*;

/**
 * An ActionListener that runs a ButtonOption's
 * {@link ButtonOption#handleAction()} method.
 */
public class ButtonOptionActionListener implements ActionListener {

    private ButtonOption o;
    private int[] affected;
    private OptionBasedWizardPanel wp;

    public ButtonOptionActionListener(ButtonOption o,
				      OptionBasedWizardPanel wp) {
	Option[] aff = o.getAffectedOptions();
	this.o=o;
	this.wp=wp;
	Option[] sets = wp.getOptionsList().getSettings();
	affected = new int[aff.length];
	outer:
	for (int i=0; i<aff.length;i++) {
	    for (int j=0;j<sets.length;j++) {
		if (sets[j] == aff[i]) {
		    affected[i] = j;
		    continue outer;
		}
	    }
	    throw new IllegalArgumentException("Cannot refresh Option: "+
					       aff[i]);
	}
    }

    public void actionPerformed(ActionEvent evt) {
	if (wp != null) {
	    Option[] sets = wp.getOptionsList().getSettings();
	    for (int i=0;i<affected.length;i++) {
		if (!wp.flushOption(affected[i], sets)) return;
	    }
	}
	o.handleAction();
	if (wp != null) {
	    Option[] sets = wp.getOptionsList().getSettings();
	    for (int i=0;i<affected.length;i++) {
		wp.refreshOption(affected[i], sets);
	    }
	}
    }
}
