package fiw.gui;
import fiw.gui.awt.*;
import fiw.core.*;

import java.awt.*;
import java.awt.event.*;

/** A Frame to select the GUI type and language. */
public class NoWizard extends Frame implements ActionListener {

    private java.awt.List list;
    
    public NoWizard() {
	super (I18n.get("Select_GUI"));
	Button b;
	Panel p;
	setBackground(Color.lightGray);
	add(p = new Panel(new GridLayout(3,1)),
	    BorderLayout.NORTH);
	p.add(b=new Button(I18n.get("Start_AWT_Wizard")));
	b.setActionCommand("AWT");
	b.addActionListener(this);
	p.add(b=new Button(I18n.get("Start_SWT_Wizard")));
	b.setActionCommand("SWT");
	b.setEnabled(false);
	p.add(b=new Button(I18n.get("Start_Swing_Wizard")));
	b.setActionCommand("Swing");

	b.setEnabled(false);
	add(p = new Panel(new BorderLayout()),
	    BorderLayout.CENTER);
	p.add(new Label(I18n.get("Languages")),
	      BorderLayout.NORTH);
	p.add(list = new java.awt.List(10), BorderLayout.CENTER);
	String[] langs = GUIHelper.getInstance().getAvailableLanguages();
	String curr = "["+GUIHelper.getInstance().getCurrentLanguage()+"]";
	int sel = -1;
	for (int i=0; i<langs.length; i++) {
	    list.add(langs[i]);
	    if (langs[i].indexOf(curr) != -1) {
		sel = i;
	    }
	}
	list.select(sel);
	p.add(b=new Button(I18n.get("Switch_Language")),
	      BorderLayout.SOUTH);
	b.setActionCommand("Lang");
	b.addActionListener(this);
	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    System.exit(0);
		}
	    });
	pack();
	show();
    }

    public void actionPerformed(ActionEvent evt) {
	String cmd=evt.getActionCommand();
	if ("AWT".equals(cmd)) {
	    dispose();
	    new Wizard();
	} else if ("Lang".equals(cmd)) {
	    String itm = list.getSelectedItem();
	    GUIHelper.getInstance().setLanguage(itm);
	    dispose();
	    new NoWizard();
	}
    }
}
