package fiw.fcp;

/**
 * Represents a SSK pair - maybe with entropy.
 */
public class SSKPair {

    private String privKey, pubKey, entropy, error;
    
    public SSKPair(String privKey, String pubKey, String entropy) {
	this.privKey=privKey;
	this.pubKey=pubKey;
	this.entropy=entropy;
    }
    
    public SSKPair(String error) {
	this.error=error;
	this.pubKey="["+error+"]";
	this.privKey="";
	this.entropy="";
    }

    /**
     * Return the error that occurred while creating the key pair, or
     * <code>null</code> if the key pair has been created
     * successfully.
     */
    public String getError() { return error; }
    public String getPrivateKey() { return privKey; }
    public String getPublicKey() { return pubKey; }
    public String getEntropy() { return entropy; }
}
