package fiw.fcp;

/**
 * Result describing a <code>RouteNotFound</code> message.
 * @author mihi
 */
public class RouteNotFoundResult extends AbstractFCPResult
    implements FCPGetResult, FCPInsertResult {

    private int unreachable, restarted, rejected;

    public RouteNotFoundResult(int unreachable, int restarted, int rejected) {
	this.unreachable=unreachable;
	this.restarted=restarted;
	this.rejected=rejected;
    }

    /**
     * Return if all nodes tried to reach have been unreachable. This
     * is equivalent to
     * <code>getRestarted() == 0 && getRejected == 0</code>
     */
    public boolean isAllUnreachable() {
	return restarted == 0 && rejected == 0;
    }

    /**
     * Return the reason why the route could not be found. This string
     * is created from the unreachable, restarted and rejected values.
     */
    public String getReasonString() {
	if (restarted==0 && rejected==0) return "["+unreachable+"]";
        return "["+unreachable+"/"+restarted+"/"+rejected+"]";
    }
    
    public boolean isError() {
	return true;
    }

    /**
     * Return how many nodes have been unreachable.
     */
    public int getUnreachable() { return unreachable;}

    /**
     * Return how many nodes restarted.
     */
    public int getRestarted() { return restarted;}

    /**
     * Return how many nodes rejected the connection.
     */
    public int getRejected() { return rejected;}
    
    public String getPayload() {return null;}
    public String getKey() { return null;}
}
