package fiw.fcp;

import java.util.List;
import java.util.ArrayList;

/**
 * Represents a FEC segment header. Usually you get lots of these when
 * preparing a FEC message. The headers' contents are only important
 * for the FEC encoding class(es), all other classes just pass these
 * things along.
 */
public class FECSegmentHeader {

    private String segHead;
    private int blockcount, blocksize;
    private int cblockcount, cblocksize;

    public FECSegmentHeader(String segHead, int bc, int bs, int cbc, int cbs) {
	this.segHead=segHead;
	blockcount=bc;
	blocksize=bs;
	cblockcount=cbc;
	cblocksize=cbs;
    }

    public String getHead() {
	return segHead;
    }
    
    public int getHeadLength() {
	return segHead.length();
    }

    public int getDataLength() {
	return blockcount*blocksize;
    }

    public int getRawDataLength() {
	return getHeadLength()+getDataLength();
    }

    public int getBlockCount() {
	return blockcount;
    }

    public int getCheckBlockCount() {
	return cblockcount;
    }
    
    public static List getBlockSizes(FECSegmentHeader[] fshs) {
	List result= new ArrayList();
	for (int i=0;i<fshs.length; i++) {
	    for (int j=0;j<fshs[i].blockcount; j++) {
		result.add(new Integer(fshs[i].blocksize));
	    }
	}
	return result;
    }

    public static List getCheckBlockSizes(FECSegmentHeader[] fshs) {
	List result= new ArrayList();
	for (int i=0;i<fshs.length; i++) {
	    for (int j=0;j<fshs[i].cblockcount; j++) {
		result.add(new Integer(fshs[i].cblocksize));
	    }
	}
	return result;
    }

}
    
