package fiw.fcp;
import java.util.List;

/**
 * A wrapper class for all the numbers calculated while fec encoding
 * which are needed again for building the splitfile metadata.
 */
public class FECMetrics {
    private FECSegmentHeader[] heads;

    /**
     * Create FECMetrics from the FECSegmentHeaders.
     */
    public FECMetrics(FECSegmentHeader[] heads) {
	this.heads=heads;
    }

    protected FECSegmentHeader[] getHeads() {
	return heads;
    }

    /** FIXME: make deprecated */
    public int[] getLegacyFECMetrics() {
	List blocksizes= FECSegmentHeader.getBlockSizes(heads);
	List checksizes=FECSegmentHeader.getCheckBlockSizes(heads);
	if (heads.length==0) return null;
	int[] ret = new int [blocksizes.size()+checksizes.size()+1];
	for (int i=0;i<blocksizes.size();i++) {
	    ret[i] = ((Integer) blocksizes.get(i)).intValue();
	}
	for (int i=0;i<checksizes.size();i++) {
	    ret[i+blocksizes.size()+1] = 
		((Integer) blocksizes.get(i)).intValue();
	}
	return ret;
    }

    public int[] getBlockMetrics() {
	List sizes= FECSegmentHeader.getBlockSizes(heads);
	if (heads.length==0) return null;
	int[] ret = new int [sizes.size()];
	for (int i=0;i<sizes.size();i++) {
	    ret[i] = ((Integer) sizes.get(i)).intValue();
	}
	return ret;
    }

    public int[] getCheckBlockMetrics() {
	List sizes= FECSegmentHeader.getCheckBlockSizes(heads);
	if (heads.length==0) return null;
	int[] ret = new int [sizes.size()];
	for (int i=0;i<sizes.size();i++) {
	    ret[i] = ((Integer) sizes.get(i)).intValue();
	}
	return ret;
    }
}
