package fiw.fcp;
import java.io.*;
import fiw.core.*; 

/**
 * An interface for {@link FECUtil} to make testing easier.
 */
public interface FECConnection {

    /**
     * Releases this singleton instance. After calling this, this
     * instance may no longer be used.
     */
    public void releaseInstance();

    /**
     * Calculates the sizes of check and data chunks for a given file size.
     * @param filesize the size of the file to encode.
     * @return the FECMetrics object for this file size
     */
    public FECMetrics getFECMetrics(long filesize);

    /**
     * Does the actual FEC encoding.
     * @param src the file to be encoded
     * @param dst the file to hold the check chunks
     * @return the FECMetrics, like {@link #getFECMetrics}, or
     * <code>null</code> if an error occurred
     */
    public FECMetrics fecEncodeFile(File src, File dst);
    
    /**
     * Does the actual FEC encoding.
     * @param src the file to be encoded
     * @param dst the file to hold the check chunks
     * @param fms the fecMetrics to be used
     * @return true iff the encoding was successful
     */
    public boolean fecEncodeFile(File src, File dst, FECMetrics fms);

    /**
     * Does the actual FEC encoding.
     * @param src the stream to be encoded
     * @param dst the stream to hold the check chunks
     * @param datasize the size of the data to be FECced
     * @return the FECMetrics, like {@link #getFECMetrics}, or
     * <code>null</code> if an error occurred
     */
    public FECMetrics fecEncodeStream(InputStreamBuilder src, OutputStream dst,
				      long datasize);
    /**
     * Does the actual FEC encoding.
     * @param src the stream to be encoded
     * @param dst the stream to hold the check chunks
     * @param fms the fecMetrics to be used
     * @return true iff the encoding was successful
     */
    public boolean fecEncodeStream(InputStreamBuilder src, OutputStream dst,
				   FECMetrics fms);

    /**
     * Creates the splitfile metadata for a FEC splitfile.
     * @param filesize the size of the file
     * @param blocks the keys for the blocks
     * @param ctype the content type to use
     * @param csum an SHA1 hash of the file
     */
    public String makeSplitfile(long filesize, String[] blocks, String ctype,
				String csum);
}
