package fiw.core.option;

import fiw.core.*;

/**
 * An OptionType that represents an integral value. Leading zeroes and
 * other fancy but unusual modifications are not allowed.
 */
public class StrictIntOptionType extends IntOptionType {

    private String whoHasProblems;
    
    public StrictIntOptionType(int min, int max, String whoHasProblems) {
	super(min, max);
	this.whoHasProblems=whoHasProblems;
    }

    public StrictIntOptionType(int min, String whoHasProblems) {
	super(min);
	this.whoHasProblems=whoHasProblems;
    }
    
    public String getInvalidReason(String s) {
	String r = super.getInvalidReason(s);
	if (r != null) return r;
	if (s.equals(""+Integer.parseInt(s))) return null;
	return I18n.format("LeadingZeroProbs", whoHasProblems);
    }
}
