package fiw.core.option;

import fiw.core.*;

/**
 * An option that represents a site type. It can have three different
 * states and saves its setting into two other options (whether it is
 * DBR and the edition number)
 * @author mihi
 */ 
public class SiteTypeOption extends Option {

    private Option dbr, ednum;
    
    /**
     * Sets the value of this option
     * @param value the new value
     * @return true iff the value is valid
     */
    public boolean setValue(String value) {
	if (!validateValue(value)) return false;
	modified=true;
	this.value=value;
	if (value.equals("DBR")) {
	    dbr.setValue("true");
	    ednum.setValue("0");
	} else if (value.equals("Edition")) {
	    if (ednum.getValue().equals("0"))
		ednum.setValue("1");
	    dbr.setValue("false");
	} else if (value.equals("One")) {
	    ednum.setValue("0");
	    dbr.setValue("false");
	}
	return true;
    }

    /**
     * Loads the value from the project settings
     * @param project the Project (-42 means global option)
     */
    public void load(int project) {
	dbr.load(project);
	ednum.load(project);
	if ("true".equals(dbr.getValue())) {
	    value = "DBR";
	} else if ("0".equals(ednum.getValue())) {
	    value = "One";
	} else {
	    value = "Edition";
	}
	modified=false;
	loaded = true;
    }

    /**
     * Saves the value into the project settings
     * @param project the Project (-42 means global option)
     */
    public void save(int project) {
	if (!modified) return;
	if (!loaded) throw new RuntimeException
			 ("Saving an option without loading it!");
	dbr.save(project);
	ednum.save(project);
	modified=false;
    }
    

    /**
     * Creates a new SiteTypeOption.
     * @param name the name of the option
     * @param panel the number of the panel on which this option is shown
     * @param dbr the option to save the dbr status in
     * @param ednum the option to save the edition number in
     */
    public SiteTypeOption (String name, int panel, Option dbr, Option ednum) {
	super(name, "<none>", "", panel,
	      new ChoiceOptionType(new String[] {"DBR", "Edition","One"},
				   new String[] {I18n.get("OptionDBRSite"),
						 I18n.get("OptionEditionSite"),
						 I18n.get("OptionOneShot")},
				   I18n.get("ErrUnknownSiteType")));
	this.dbr=dbr;
	this.ednum=ednum;
    }
}
    
