package fiw.core.option;
import fiw.core.*;

/**
 * Class containing all project options.
 * @author mihi
 */
public class Options extends AbstractOptions {

    private Option pubkey, privkey, dbr, ednum, inc, offs, nim, checkednims,
	nimprefix, entropy;
    private OptionEnabler oe;

    /** all available settings with values */
    private final Option[] settings;

    private Options() {
	ednum = new Option(I18n.get("OptionEdition"), "editionx","0",8,
			   new StrictIntOptionType(0,
						   I18n.get("ProbsCatalogs")),
			   oe = new OptionEnabler(null, "0", false));
	oe.setOption(ednum);
	nimprefix = new Option(I18n.get("OptionNIMPrefix"),"nimprefix","",5);
	nim = new Option(I18n.get("OptionNextNIM"),"nextnim","1",8,
			 new StrictIntOptionType(1, I18n.get("ProbsNIMUtils")),
			 new OptionEnabler(nimprefix, "", false));
	nim.setDisabledDefault("");
	settings = new Option[] {
	    new Option(I18n.get("OptionProjName"),"name","Sample project",3),
	    new Option(I18n.get("GenSSKPair"),1,1001), //special
	    pubkey =  new Option(I18n.get("OptionPubKey"),"pubkey","",3),
	    privkey = new Option(I18n.get("OptionPrivKey"),"privkey","",3),
	    entropy = new Option(I18n.get("OptionEntropy"),"entropy","",3),
	    new GenerateKeyButtonOption(I18n.get("GenSSKPair"),3,
					pubkey, privkey, entropy),
	    new Option(I18n.get("OptionKeyDir"),"keydir","samplepage",3),
	    new Option(I18n.get("OptionPath"),"path","",3),
	    new Option(I18n.get("OptionCharset"),"charset","",3),
	    dbr = new Option(I18n.get("OptionDBRSite"), "dbr", "false",
			     1000, BOOL),
	    new SiteTypeOption(I18n.get("OptionSiteType"),3, dbr, ednum),
	    new Option("Check settings",5,1001), // special
	    new Option("DBR settings header/skipper",6, 4),
	    inc = new Option(I18n.get("OptionDBRInc"), "dbr.increment",
			     "86400", 4, new DayTimeOptionType(1)),
	    offs = new Option(I18n.get("OptionDBROffs"),"dbr.offset","0",4,
			      new DayTimeOptionType(0)),
//	    new Option("Insert DBR also at", "dbr.location", "", 4),
	    new Option(I18n.get("OptionALink"), "activelink",
		       "activelink.png", 5),
	    nimprefix,
	    new Option("Additional files to parse",4,1001), // special
	    new Option(I18n.get("OptionTitle"),"title","My new freesite",6),
	    new Option(I18n.get("OptionCategory"),"category","Software",6),
	    new Option(I18n.get("OptionAuthor"),"author","anonymous",6),
	    new Option(I18n.get("OptionDesc"),3,1001), // special
	    ednum,
	    checkednims = new Option("Already found NIMs","checkednims","",-1),
	    nim,
	    new NimUpdateButtonOption(I18n.get("UpdateNIM"), 8, nim,
				      checkednims, nimprefix),
	    new Option(I18n.get("OptionDBRFirst"), "dbr.first","0",8,
		       new DBRSlotOptionType(inc, offs),
		       new OptionEnabler(dbr, "true", true)),
	    new Option(I18n.get("OptionDBRLast"),"dbr.last","0",8,
		       new DBRSlotOptionType(inc, offs),
		       new OptionEnabler(dbr, "true", true)),
	    new Option(I18n.get("OptionHTL"), "htl", "15", 8,
		       new IntOptionType(0, 100)),
	    new Option(I18n.get("OptionLockTime"), "lockedtime", "",
		       8, new TimestampOptionType()),
	};
    }
	
    /**
     * Returns all settings.
     */
    public Option[] getSettings() {
	return settings;
    }

    /** The project number for this Options object */
    private int project;

    /**
     * Creates an Options object containing options for a specified
     * project.
     * @param project the project
     */
    public Options(int project) {
	this();
	load(project);
    }

    /**
     * The ProjectKnower that knows which project to load.
     */
    private ProjectKnower pk = null;

    /**
     * Creates an Options object that may represent different projects
     * on subsequent {@link #load()}s.
     * @param pk a ProjectKnower that knows which project to load.
     */
    public Options(ProjectKnower pk) {
	this();
	this.pk=pk;
	load(0);
    }

    /**
     * (Re)loads these Options.
     */
    public void load() {
	if (pk != null) {
	    project = pk.getProjectNumber();
	}
	load0();
    }

    /**
     * internal loader function.
     */
    private void load0() {
	for (int i=0;i<settings.length;i++) {
	    settings[i].load(project);
	}
    }

    /**
     * Loads options from a different project into this Options object.
     */
    public void load(int project) {
	this.project=project;
	load0();
    }

    /**
     * Saves all modified options.
     */
    public void save() {
	for (int i=0;i<settings.length;i++) {
	    settings[i].save(project);
	}
    }
}
