package fiw.core.option;

/**
 * represents a type of an option (e.g. string, integer, ...) and can check
 * if a given string value is valid.
 * @author mihi
 */
public abstract class OptionType {
    
    /**
     * Checks if a value is valid.
     * @param s the value
     * @return <code>true</code> iff the value is valid
     */
    public boolean isValid(String s) {
	return getInvalidReason(s) == null;
    }
    /**
     * Returns the reason why a value is invalid.
     * @param s the value
     * @return the reason, or <code>null</code> if the value is valid.
     */
    public abstract String getInvalidReason(String s);
}
