package fiw.core.option;

/**
 * Determines whether an option should be enabled (changable by the
 * user) or not - based on another option.
 */
public class OptionEnabler implements Enabler {

    private Option o;
    private String compare;
    private boolean equal;
    
    public OptionEnabler(Option o, String compare, boolean equal) {
	this.o=o;
	this.compare = compare;
	this.equal = equal;
    }

    public void setOption(Option o) {
	this.o = o;
    }
    public boolean isEnabled() {
	boolean res = compare.equals(o.getValue());
	if (!equal) res = !res;
	return res;
    }
}
