package fiw.core.option;

/**
 * Option that can generate new key pairs
 * @author mihi
 */ 
public class NimUpdateButtonOption extends ButtonOption {

    private Option nim, checkednims;

    public NimUpdateButtonOption(String title, int panel,
				 Option nim, Option checkednims,
				 Option nimprefix) {
	super(title, panel, true, new OptionEnabler(nimprefix, "", false));
	this.nim=nim;
	this.checkednims=checkednims;
    }

    public Option[] getAffectedOptions() {
	return new Option[] {nim, checkednims};
    }
    
    public void handleAction(){
	String fetchednims=checkednims.getValue();
	int nimnum=Integer.parseInt(nim.getValue());
	while(fetchednims.indexOf("("+nimnum+")") != -1) {
	    nimnum++;
	}
	nim.setValue(""+nimnum);
    }
}
