package fiw.core.option;

/**
 * An OptionType that represents a long integral value
 */
public class LongOptionType extends OptionType {

    private long min,max;
    
    public LongOptionType(long min, long max) {
	this.min = min;
	this.max = max;
    }

    public LongOptionType(long min) {
	this(min,Long.MAX_VALUE);
    }
    
    public long getMin() { return min;}
    public long getMax() { return max;}

    public String getInvalidReason(String s) {
	try {
	    long i = Long.parseLong(s);
	    if (i>=min && i <=max) return null;
	    return "Value must be between "+min+" and "+max;
	} catch (NumberFormatException ex) {
	    return "Not a number: "+s;
	}
    }
}
