package fiw.core.option;

/**
 * An OptionType that represents an integral value
 */
public class IntOptionType extends OptionType {

    private int min,max;
    
    public IntOptionType(int min, int max) {
	this.min = min;
	this.max = max;
    }

    public IntOptionType(int min) {
	this(min,Integer.MAX_VALUE);
    }
    
    public int getMin() { return min;}
    public int getMax() { return max;}

    public String getInvalidReason(String s) {
	try {
	    int i = Integer.parseInt(s);
	    if (i>=min && i <=max) return null;
	    return "Value must be between "+min+" and "+max;
	} catch (NumberFormatException ex) {
	    return "Not a number: "+s;
	}
    }
}
