package fiw.core.option;
import fiw.core.*;
import fiw.fcp.*;

/**
 * Option that can generate new key pairs
 * @author mihi
 */ 
public class GenerateKeyButtonOption extends ButtonOption {

    private Option pubkey, privkey, entropy;
    public GenerateKeyButtonOption(String title, int panel, Option pubkey,
				   Option privkey, Option entropy) {
	super(title, panel, false);
	this.pubkey=pubkey;
	this.privkey=privkey;
	this.entropy = entropy;
    }

    public Option[] getAffectedOptions() {
	return new Option[] {pubkey, privkey, entropy};
    }
    
    public void handleAction(){
	String pub = pubkey.getValue();
	if (pub.startsWith("#")) {
	    try {
		int num=Integer.parseInt(pub.substring(1));
		Settings ss= FIWSystem.getInstance().getSettings();
		if (num >0 && num <= ss.getProjCount()) {
		    pubkey.setValue(ss.getProjectSetting
				(num-1,"pubkey"));
		    privkey.setValue(ss.getProjectSetting
				 (num-1,"privkey"));
		    entropy.setValue(ss.getProjectSetting
				 (num-1,"entropy"));
		    return;
		}	
	    } catch(NumberFormatException e) {
		// just go on...
	    }
	}
	FCPConnection fc = FIWSystem.getInstance().getFCPConnection();
	SSKPair kp =fc.getNewSSK();
	privkey.setValue(kp.getPrivateKey());
	pubkey.setValue(kp.getPublicKey());
	entropy.setValue(kp.getEntropy());
    }
}
