package fiw.core.option;

/**
 * An OptionType that represents an integral value
 */
public class DBRSlotOptionType extends LongOptionType {

    private Option increment, offset;
    
    public DBRSlotOptionType(Option increment, Option offset) {
	super(0);
	this.increment=increment;
	this.offset=offset;	
    }

    public Option getIncrement() { return increment; }
    public Option getOffset() { return offset; }
    
    public String getInvalidReason(String s) {
	String r = super.getInvalidReason(s);
	if (r != null) return r;
	long i = Long.parseLong(s);
	int inc = Integer.parseInt(increment.getValue());
	int offs = Integer.parseInt(offset.getValue());
	i-=offs;
	if (i% inc == 0) return null;
	return "Value does not match to given DBR increment/offset";
    }
}
